/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.mechanics.stamina;

import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.common.util.CommonUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.studio4sv.tponr.mechanics.stamina.PlayerStaminaProvider;
import org.studio4sv.tponr.networking.ModMessages;
import org.studio4sv.tponr.networking.packet.S2C.StaminaDataSyncS2CPacket;

@Mod.EventBusSubscriber(modid="tponr")
public class StaminaHandler {
    public static final float SPRINT_COST = 0.3f;
    public static final int JUMP_COST = 5;
    public static final int MINING_COST = 10;
    private static final int REGEN_AMOUNT = 5;
    private static final int REGEN_COOLDOWN = 30;
    private static int regenTickCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side != LogicalSide.SERVER || event.phase != TickEvent.Phase.END) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)event.player;
        serverPlayer.getCapability(PlayerStaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> {
            boolean syncNeeded = false;
            if (serverPlayer.m_20142_() && !serverPlayer.m_7500_() && !serverPlayer.m_5833_() && stamina.getStamina() > 0.3f) {
                stamina.subStamina(0.3f);
                regenTickCounter = 0;
                syncNeeded = true;
            }
            if (++regenTickCounter >= 30) {
                regenTickCounter = 0;
                if (!serverPlayer.m_20142_()) {
                    stamina.addStamina(5);
                    syncNeeded = true;
                }
            }
            if (syncNeeded) {
                StaminaHandler.syncStamina(serverPlayer, stamina.getStamina(), stamina.getMaxStamina());
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
        serverPlayer.getCapability(PlayerStaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> {
            if (!(serverPlayer.m_20069_() || serverPlayer.m_20077_() || !(stamina.getStamina() >= 5.0f) || serverPlayer.m_7500_() || serverPlayer.m_5833_())) {
                stamina.subStamina(5.0f);
                regenTickCounter = 0;
                StaminaHandler.syncStamina(serverPlayer, stamina.getStamina(), stamina.getMaxStamina());
            }
        });
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        serverPlayer.getCapability(PlayerStaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> {
            if (stamina.getStamina() > 10.0f) {
                if (serverPlayer.m_7500_() && !serverPlayer.m_5833_()) {
                    stamina.subStamina(10.0f);
                }
                regenTickCounter = 0;
                StaminaHandler.syncStamina(serverPlayer, stamina.getStamina(), stamina.getMaxStamina());
            } else {
                AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((Player)event.getPlayer());
                if (damageModel != null) {
                    damageModel.LEFT_ARM.damage(1.0f, event.getPlayer(), true);
                    damageModel.RIGHT_ARM.damage(1.0f, event.getPlayer(), true);
                    damageModel.scheduleResync();
                } else {
                    event.setCanceled(true);
                }
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        StaminaHandler.syncIfServerPlayer(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        StaminaHandler.syncIfServerPlayer(event.getEntity());
    }

    private static void syncIfServerPlayer(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)player).m_9236_().m_5776_()) {
            serverPlayer.getCapability(PlayerStaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> StaminaHandler.syncStamina(serverPlayer, stamina.getStamina(), stamina.getMaxStamina()));
        }
    }

    private static void syncStamina(ServerPlayer player, float stamina, int maxStamina) {
        ModMessages.sendToPlayer(new StaminaDataSyncS2CPacket(stamina, maxStamina), player);
    }
}

