/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.networking.packet.C2S;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import org.studio4sv.tponr.blocks.entity.SuitDyer.SuitDyerBlockEntity;

public class DyerChangeColorS2CPacket {
    private final BlockPos pos;
    private final int color;

    public DyerChangeColorS2CPacket(int color, BlockPos pos) {
        this.color = color;
        this.pos = pos;
    }

    public DyerChangeColorS2CPacket(FriendlyByteBuf buf) {
        this.color = buf.readInt();
        this.pos = buf.m_130135_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.color);
        buf.m_130064_(this.pos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (blockEntity != null && blockEntity instanceof SuitDyerBlockEntity) {
                SuitDyerBlockEntity dyer = (SuitDyerBlockEntity)blockEntity;
                dyer.setColor(this.color);
                level.m_7260_(this.pos, dyer.m_58900_(), dyer.m_58900_(), 3);
            }
        });
        return true;
    }
}

