/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.networking.packet.S2C;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.studio4sv.tponr.client.ClientAttributesData;

public class AttributesDataSyncS2CPacket {
    private final Map<String, Integer> attributes;

    public AttributesDataSyncS2CPacket(Map<String, Integer> attributes) {
        this.attributes = attributes;
    }

    public AttributesDataSyncS2CPacket(FriendlyByteBuf buf) {
        this.attributes = new HashMap<String, Integer>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            String key = buf.m_130277_();
            int value = buf.readInt();
            this.attributes.put(key, value);
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.attributes.size());
        for (Map.Entry<String, Integer> entry : this.attributes.entrySet()) {
            buf.m_130070_(entry.getKey());
            buf.writeInt(entry.getValue().intValue());
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ClientAttributesData.set(this.attributes));
        return true;
    }
}

