/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.networking.packet.S2C;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.studio4sv.tponr.client.ClientSafeAreaTracker;

public class SafeAreaSyncS2CPacket {
    private final ResourceKey<Level> dimension;
    private final BlockPos pos;
    private final Set<BlockPos> safeArea = new HashSet<BlockPos>();
    private final ACTIONS action;

    public SafeAreaSyncS2CPacket(ResourceKey<Level> dimension, BlockPos pos, ACTIONS action) {
        this.dimension = dimension;
        this.pos = pos;
        this.action = action;
    }

    public SafeAreaSyncS2CPacket(ResourceKey<Level> dimension, Set<BlockPos> safeArea) {
        this.dimension = dimension;
        this.safeArea.addAll(safeArea);
        this.pos = null;
        this.action = ACTIONS.add;
    }

    public SafeAreaSyncS2CPacket(FriendlyByteBuf buf) {
        this.dimension = buf.m_236801_(Registries.f_256858_);
        boolean hasPos = buf.readBoolean();
        this.pos = hasPos ? buf.m_130135_() : null;
        int size = buf.readInt();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                this.safeArea.add(buf.m_130135_());
            }
        }
        this.action = (ACTIONS)buf.m_130066_(ACTIONS.class);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimension.m_135782_());
        buf.writeBoolean(this.pos != null);
        if (this.pos != null) {
            buf.m_130064_(this.pos);
        }
        buf.writeInt(this.safeArea.size());
        for (BlockPos blockPos : this.safeArea) {
            buf.m_130064_(blockPos);
        }
        buf.m_130068_((Enum)this.action);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            if (!this.safeArea.isEmpty()) {
                ClientSafeAreaTracker.setSafeArea(this.dimension, this.safeArea);
            } else if (this.action == ACTIONS.add) {
                ClientSafeAreaTracker.addSafeArea(this.dimension, this.pos);
            } else if (this.action == ACTIONS.remove) {
                ClientSafeAreaTracker.removeSafeArea(this.dimension, this.pos);
            }
        });
        return true;
    }

    public static enum ACTIONS {
        add,
        remove;

    }
}

