/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.networking.packet.S2C;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.studio4sv.tponr.client.ClientStaminaData;
import org.studio4sv.tponr.client.hud.StaminaHud;

public class StaminaDataSyncS2CPacket {
    private final float stamina;
    private final int maxStamina;

    public StaminaDataSyncS2CPacket(float stamina, int maxStamina) {
        this.stamina = stamina;
        this.maxStamina = maxStamina;
    }

    public StaminaDataSyncS2CPacket(FriendlyByteBuf buf) {
        this.stamina = buf.readFloat();
        this.maxStamina = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.stamina);
        buf.writeInt(this.maxStamina);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            StaminaHud.setStaminaAmount(this.stamina);
            ClientStaminaData.set(this.stamina);
            ClientStaminaData.setMax(this.maxStamina);
        });
        return true;
    }
}

