/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.registers.event;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.studio4sv.tponr.armor.HazmatSuitItem;
import org.studio4sv.tponr.client.UpgradeScreenKeyHandler;
import org.studio4sv.tponr.client.gui.UpgradeScreen;
import org.studio4sv.tponr.client.hud.SuitOverlayHud;
import org.studio4sv.tponr.client.hud.XpHud;
import org.studio4sv.tponr.util.armor.HazmatArmorTracker;
import org.studio4sv.tponr.util.xpConverter;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void disableHud(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() == VanillaGuiOverlay.FOOD_LEVEL.type()) {
            event.setCanceled(true);
        }
        if (event.getOverlay() == VanillaGuiOverlay.EXPERIENCE_BAR.type()) {
            event.setCanceled(true);
        }
        if (event.getOverlay() == VanillaGuiOverlay.ARMOR_LEVEL.type()) {
            event.setCanceled(true);
        }
        if (event.getOverlay() == VanillaGuiOverlay.AIR_LEVEL.type()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_9236_().f_46443_ && player == Minecraft.m_91087_().f_91074_) {
            HazmatArmorTracker.updateForPlayer(player);
        }
        int level = player.f_36078_;
        float progress = player.f_36080_;
        int totalXP = xpConverter.calculate(level, progress);
        XpHud.setPoints(totalXP);
        SuitOverlayHud.setEnabled(player.m_21033_(EquipmentSlot.HEAD) && player.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof HazmatSuitItem);
        if (player.m_21033_(EquipmentSlot.CHEST)) {
            SuitOverlayHud.setCharge(player.m_6844_(EquipmentSlot.CHEST).m_41784_().m_128457_("charge"));
        }
    }

    @SubscribeEvent
    public static void onRenderPlayer(RenderLivingEvent.Pre<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> event) {
        if (!(event.getEntity() instanceof AbstractClientPlayer)) {
            return;
        }
        PlayerModel model = (PlayerModel)event.getRenderer().m_7200_();
        if (!HazmatArmorTracker.headVisible) {
            model.f_102808_.f_104207_ = false;
            model.f_102809_.f_104207_ = false;
        }
        if (!HazmatArmorTracker.bodyVisible) {
            model.f_102810_.f_104207_ = false;
            model.f_102812_.f_104207_ = false;
            model.f_102811_.f_104207_ = false;
            model.f_103378_.f_104207_ = false;
            model.f_103374_.f_104207_ = false;
            model.f_103375_.f_104207_ = false;
        }
        if (!HazmatArmorTracker.legsVisible) {
            model.f_102814_.f_104207_ = false;
            model.f_102813_.f_104207_ = false;
            model.f_103376_.f_104207_ = false;
            model.f_103377_.f_104207_ = false;
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerPost(RenderLivingEvent.Post<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> event) {
        if (!(event.getEntity() instanceof AbstractClientPlayer)) {
            return;
        }
        PlayerModel model = (PlayerModel)event.getRenderer().m_7200_();
        model.f_102808_.f_104207_ = true;
        model.f_102809_.f_104207_ = true;
        model.f_102810_.f_104207_ = true;
        model.f_102812_.f_104207_ = true;
        model.f_102811_.f_104207_ = true;
        model.f_103378_.f_104207_ = true;
        model.f_103374_.f_104207_ = true;
        model.f_103375_.f_104207_ = true;
        model.f_102814_.f_104207_ = true;
        model.f_102813_.f_104207_ = true;
        model.f_103376_.f_104207_ = true;
        model.f_103377_.f_104207_ = true;
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        if (UpgradeScreenKeyHandler.OPEN_UPGRADE_SCREEN.m_90859_()) {
            Minecraft.m_91087_().m_91152_((Screen)new UpgradeScreen());
        }
    }
}

