/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.registers.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.studio4sv.tponr.TPONR;
import org.studio4sv.tponr.armor.HazmatSuitItem;
import org.studio4sv.tponr.commands.HUDControllerCommands;
import org.studio4sv.tponr.mechanics.attributes.PlayerAttributes;
import org.studio4sv.tponr.mechanics.attributes.PlayerAttributesProvider;
import org.studio4sv.tponr.mechanics.stamina.PlayerStamina;
import org.studio4sv.tponr.mechanics.stamina.PlayerStaminaProvider;
import org.studio4sv.tponr.networking.ModMessages;
import org.studio4sv.tponr.networking.packet.S2C.AttributesDataSyncS2CPacket;
import org.studio4sv.tponr.networking.packet.S2C.SafeAreaSyncS2CPacket;
import org.studio4sv.tponr.networking.packet.S2C.StaminaDataSyncS2CPacket;
import org.studio4sv.tponr.registers.ModItems;
import org.studio4sv.tponr.util.RadiationUtils;
import org.studio4sv.tponr.util.SafeAreaTracker;

@Mod.EventBusSubscriber(modid="tponr")
public class ModEvents {
    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            if (!((Entity)event.getObject()).getCapability(PlayerStaminaProvider.PLAYER_STAMINA).isPresent()) {
                event.addCapability(TPONR.id("stamina"), (ICapabilityProvider)new PlayerStaminaProvider());
            }
            if (!((Entity)event.getObject()).getCapability(PlayerAttributesProvider.PLAYER_ATTRIBUTES).isPresent()) {
                event.addCapability(TPONR.id("attributes"), (ICapabilityProvider)new PlayerAttributesProvider());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerStaminaProvider.PLAYER_STAMINA).ifPresent(oldStore -> event.getEntity().getCapability(PlayerStaminaProvider.PLAYER_STAMINA).ifPresent(newStore -> newStore.copyFrom((PlayerStamina)oldStore)));
            event.getOriginal().getCapability(PlayerAttributesProvider.PLAYER_ATTRIBUTES).ifPresent(oldStore -> event.getEntity().getCapability(PlayerAttributesProvider.PLAYER_ATTRIBUTES).ifPresent(newStore -> newStore.copyFrom((PlayerAttributes)oldStore)));
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PlayerStamina.class);
        event.register(PlayerAttributes.class);
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        Object object;
        if (!event.getLevel().m_5776_() && (object = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)object;
            player.getCapability(PlayerStaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> ModMessages.sendToPlayer(new StaminaDataSyncS2CPacket(stamina.getStamina(), stamina.getMaxStamina()), player));
            player.getCapability(PlayerAttributesProvider.PLAYER_ATTRIBUTES).ifPresent(attributes -> ModMessages.sendToPlayer(new AttributesDataSyncS2CPacket(attributes.getAttributes()), player));
            for (ServerLevel level : player.f_8924_.m_129785_()) {
                SafeAreaTracker tracker = SafeAreaTracker.get(level);
                if (tracker.getAllSafeBlocks().isEmpty()) continue;
                ModMessages.sendToPlayer(new SafeAreaSyncS2CPacket((ResourceKey<Level>)level.m_46472_(), tracker.getAllSafeBlocks()), player);
            }
        }
    }

    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        HUDControllerCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onArmorRemoved(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (event.getSlot().m_20743_() != EquipmentSlot.Type.ARMOR) {
            return;
        }
        ItemStack oldItem = event.getFrom();
        ItemStack newItem = event.getTo();
        if (!(oldItem.m_41720_() instanceof HazmatSuitItem)) {
            return;
        }
        if (newItem.m_41720_() instanceof HazmatSuitItem) {
            return;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack armor;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || !((armor = player.m_6844_(slot)).m_41720_() instanceof HazmatSuitItem)) continue;
            player.m_8061_(slot, ItemStack.f_41583_);
        }
        int color = ((DyeableLeatherItem)oldItem.m_41720_()).m_41121_(oldItem);
        float charge = oldItem.m_41784_().m_128441_("charge") ? oldItem.m_41784_().m_128457_("charge") : 0.0f;
        ItemStack suitPack = ModEvents.createHazmatSuitPack(color, charge);
        player.f_36096_.m_142503_(ItemStack.f_41583_);
        player.f_36096_.m_142503_(suitPack);
    }

    private static ItemStack createHazmatSuitPack(int color, float charge) {
        ItemStack suitPack = new ItemStack((ItemLike)ModItems.HAZMAT_SUIT_PACK.get());
        ((DyeableLeatherItem)suitPack.m_41720_()).m_41115_(suitPack, color);
        CompoundTag tag = suitPack.m_41784_();
        tag.m_128350_("charge", charge);
        return suitPack;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().f_46443_) {
            ServerPlayer player = (ServerPlayer)event.player;
            if (player.m_150110_().f_35937_) {
                return;
            }
            int radiationLevel = RadiationUtils.levelForPlayer((Player)player);
            AtomicInteger equippedSuitParts = new AtomicInteger();
            if (radiationLevel > 0) {
                player.m_6168_().forEach(slot -> {
                    if (slot.m_41720_() instanceof HazmatSuitItem) {
                        equippedSuitParts.getAndIncrement();
                    }
                });
                if (equippedSuitParts.get() != 4) {
                    player.m_6469_(player.m_269291_().m_269425_(), 0.5f + 0.5f * (float)radiationLevel);
                } else {
                    player.m_6168_().forEach(slot -> {
                        Item patt7175$temp = slot.m_41720_();
                        if (patt7175$temp instanceof HazmatSuitItem) {
                            HazmatSuitItem suitItem = (HazmatSuitItem)patt7175$temp;
                            if (suitItem.getEnergy((ItemStack)slot) <= 0.0f) {
                                player.m_6469_(player.m_269291_().m_269425_(), 0.5f + 0.5f * (float)radiationLevel);
                            }
                            suitItem.changeEnergy((ItemStack)slot, -0.01f * (float)radiationLevel);
                        }
                    });
                }
            }
        }
    }
}

