/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.util;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.studio4sv.tponr.TPONR;
import org.studio4sv.tponr.blocks.custom.BunkerDoor.BunkerDoorBlock;
import org.studio4sv.tponr.blocks.custom.BunkerDoor.BunkerDoorSubBlock;
import org.studio4sv.tponr.blocks.entity.BunkerDoor.BunkerDoorBlockEntity;
import org.studio4sv.tponr.blocks.entity.BunkerDoor.BunkerDoorSubBlockEntity;
import org.studio4sv.tponr.client.ClientSafeAreaTracker;
import org.studio4sv.tponr.registers.ModTags;
import org.studio4sv.tponr.util.SafeAreaTracker;

public class RadiationUtils {
    public static boolean isSealValid(BlockState state, BlockPos pos, Level level) {
        if (!state.m_204336_(ModTags.Blocks.SEAL_BLOCKS)) {
            return false;
        }
        Block block = state.m_60734_();
        if (block instanceof BunkerDoorBlock) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof BunkerDoorBlockEntity) {
                BunkerDoorBlockEntity door = (BunkerDoorBlockEntity)be;
                return !door.isOpen();
            }
            return false;
        }
        if (block instanceof BunkerDoorSubBlock) {
            BunkerDoorSubBlockEntity sub;
            BlockPos mainPos;
            BlockEntity mainBe;
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof BunkerDoorSubBlockEntity && (mainBe = level.m_7702_(mainPos = (sub = (BunkerDoorSubBlockEntity)be).getMainBlockPos())) instanceof BunkerDoorBlockEntity) {
                BunkerDoorBlockEntity main = (BunkerDoorBlockEntity)mainBe;
                return !main.isOpen();
            }
            return false;
        }
        return true;
    }

    public static int levelForPlayer(Player player) {
        Level level;
        Biome biome = (Biome)player.m_9236_().m_204166_(player.m_20183_()).m_203334_();
        float temp = Math.abs(biome.m_47554_());
        BlockPos blockBottom = player.m_20183_().m_7495_();
        BlockPos blockTop = player.m_20183_().m_7494_();
        if (!player.m_9236_().m_5776_() && (level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SafeAreaTracker tracker = SafeAreaTracker.get(serverLevel);
            if (tracker.isSafe(blockBottom) && tracker.isSafe(blockTop)) {
                return 0;
            }
            if (player.m_9236_().m_46472_().m_135782_().equals((Object)TPONR.BUNKER_MOD_SAFE)) {
                return 0;
            }
        } else if (player.m_9236_().m_5776_()) {
            ResourceKey dimension = player.m_9236_().m_46472_();
            if (ClientSafeAreaTracker.isSafe((ResourceKey<Level>)dimension, blockBottom) && ClientSafeAreaTracker.isSafe((ResourceKey<Level>)dimension, blockTop)) {
                return 0;
            }
            if (dimension.m_135782_().equals((Object)TPONR.BUNKER_MOD_SAFE)) {
                return 0;
            }
        }
        return RadiationUtils.radTable(Float.valueOf(temp));
    }

    public static int levelFromPos(BlockPos pos, Level level) {
        ServerLevel serverLevel;
        SafeAreaTracker tracker;
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        float temp = Math.abs(biome.m_47554_());
        if (level instanceof ServerLevel && (tracker = SafeAreaTracker.get(serverLevel = (ServerLevel)level)).isSafe(pos)) {
            return 0;
        }
        return RadiationUtils.radTable(Float.valueOf(temp));
    }

    public static int radTable(Float temp) {
        if (temp.floatValue() <= 0.15f) {
            return 1;
        }
        if (temp.floatValue() <= 0.3f) {
            return 2;
        }
        if (temp.floatValue() <= 0.9f) {
            return 3;
        }
        if (temp.floatValue() <= 1.5f) {
            return 4;
        }
        if (temp.floatValue() <= 2.0f) {
            return 5;
        }
        return 6;
    }
}

