/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.util;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.studio4sv.tponr.networking.ModMessages;
import org.studio4sv.tponr.networking.packet.S2C.SafeAreaSyncS2CPacket;

public class SafeAreaTracker
extends SavedData {
    private final Set<BlockPos> safeArea = new HashSet<BlockPos>();
    private final ServerLevel level;

    public SafeAreaTracker(ServerLevel level) {
        this.level = level;
    }

    public static SafeAreaTracker load(CompoundTag tag, ServerLevel level) {
        SafeAreaTracker tracker = new SafeAreaTracker(level);
        ListTag list = tag.m_128437_("SafeBlocks", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag posTag = list.m_128728_(i);
            tracker.safeArea.add(new BlockPos(posTag.m_128451_("x"), posTag.m_128451_("y"), posTag.m_128451_("z")));
        }
        return tracker;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (BlockPos pos : this.safeArea) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("x", pos.m_123341_());
            posTag.m_128405_("y", pos.m_123342_());
            posTag.m_128405_("z", pos.m_123343_());
            list.add((Object)posTag);
        }
        tag.m_128365_("SafeBlocks", (Tag)list);
        return tag;
    }

    public void addSafeArea(BlockPos pos) {
        if (this.safeArea.add(pos)) {
            for (ServerPlayer player : this.level.m_6907_()) {
                ModMessages.sendToPlayer(new SafeAreaSyncS2CPacket((ResourceKey<Level>)this.level.m_46472_(), pos, SafeAreaSyncS2CPacket.ACTIONS.add), player);
            }
            this.m_77762_();
        }
    }

    public void removeSafeArea(BlockPos pos) {
        if (this.safeArea.remove(pos)) {
            for (ServerPlayer player : this.level.m_6907_()) {
                ModMessages.sendToPlayer(new SafeAreaSyncS2CPacket((ResourceKey<Level>)this.level.m_46472_(), pos, SafeAreaSyncS2CPacket.ACTIONS.remove), player);
            }
            this.m_77762_();
        }
    }

    public boolean isSafe(BlockPos pos) {
        return this.safeArea.contains(pos);
    }

    public Set<BlockPos> getAllSafeBlocks() {
        return this.safeArea;
    }

    public static SafeAreaTracker get(ServerLevel level) {
        return (SafeAreaTracker)level.m_8895_().m_164861_(tag -> SafeAreaTracker.load(tag, level), () -> new SafeAreaTracker(level), "safe_area");
    }
}

