/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.util;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class TextOnlyButton
extends Button {
    private final float scale;
    private final int color;
    private final int yOffset;

    public TextOnlyButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, float scale, int color, int yOffset) {
        super(x, y, width, height, message, onPress, f_252438_);
        this.scale = scale;
        this.color = color;
        this.yOffset = yOffset;
    }

    public TextOnlyButton(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
        this(x, y, width, height, message, onPress, 1.0f);
    }

    public TextOnlyButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, float scale) {
        this(x, y, width, height, message, onPress, scale, 0xFFFFFF);
    }

    public TextOnlyButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, float scale, int color) {
        this(x, y, width, height, message, onPress, scale, color, 0);
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.f_93624_) {
            Font font = Minecraft.m_91087_().f_91062_;
            Component message = this.m_6035_();
            int textWidth = (int)((float)font.m_92852_((FormattedText)message) * this.scale);
            Objects.requireNonNull(font);
            int textHeight = (int)(9.0f * this.scale);
            int xPos = this.m_252754_() + (this.m_5711_() - textWidth) / 2;
            int yPos = this.m_252907_() + (this.m_93694_() - textHeight) / 2;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)xPos, (float)yPos, 0.0f);
            guiGraphics.m_280168_().m_85841_(this.scale, this.scale, 1.0f);
            guiGraphics.m_280614_(font, message, 0, this.yOffset, this.color, false);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public static Builder textOnlyBuilder(Component message, Button.OnPress onPress) {
        return new Builder(message, onPress);
    }

    public static class Builder {
        private final Component message;
        private final Button.OnPress onPress;
        private int x;
        private int y;
        private int width;
        private int height;
        private float scale = 1.0f;
        private int color = 0xFFFFFF;
        private int yOffset = 0;

        public Builder(Component message, Button.OnPress onPress) {
            this.message = message;
            this.onPress = onPress;
        }

        public Builder bounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder scale(float scale) {
            this.scale = scale;
            return this;
        }

        public Builder color(int color) {
            this.color = color;
            return this;
        }

        public Builder yOffset(int yOffset) {
            this.yOffset = yOffset;
            return this;
        }

        public TextOnlyButton build() {
            return new TextOnlyButton(this.x, this.y, this.width, this.height, this.message, this.onPress, this.scale, this.color, this.yOffset);
        }
    }
}

