/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.ConsoleHandler;
import nl.aurorion.blockregen.GsonHelper;
import nl.aurorion.blockregen.Message;
import nl.aurorion.blockregen.MetricsLite;
import nl.aurorion.blockregen.UpdateCheck;
import nl.aurorion.blockregen.command.Commands;
import nl.aurorion.blockregen.compatibility.CompatibilityManager;
import nl.aurorion.blockregen.configuration.Files;
import nl.aurorion.blockregen.drop.ItemManager;
import nl.aurorion.blockregen.event.EventManager;
import nl.aurorion.blockregen.json.gson.GsonBuilder;
import nl.aurorion.blockregen.listener.PhysicsListener;
import nl.aurorion.blockregen.listener.PlayerListener;
import nl.aurorion.blockregen.listener.RegenerationListener;
import nl.aurorion.blockregen.material.MaterialManager;
import nl.aurorion.blockregen.material.parser.MinecraftMaterialParser;
import nl.aurorion.blockregen.particle.ParticleManager;
import nl.aurorion.blockregen.particle.impl.FireCube;
import nl.aurorion.blockregen.particle.impl.FireWorks;
import nl.aurorion.blockregen.particle.impl.FlameCrown;
import nl.aurorion.blockregen.particle.impl.WitchSpell;
import nl.aurorion.blockregen.preset.PresetManager;
import nl.aurorion.blockregen.preset.condition.DefaultConditions;
import nl.aurorion.blockregen.preset.condition.GenericConditionProvider;
import nl.aurorion.blockregen.regeneration.RegenerationManager;
import nl.aurorion.blockregen.region.RegionManager;
import nl.aurorion.blockregen.version.NodeDataAdapter;
import nl.aurorion.blockregen.version.NodeDataInstanceCreator;
import nl.aurorion.blockregen.version.VersionManager;
import nl.aurorion.blockregen.version.VersionManagerImpl;
import nl.aurorion.blockregen.version.api.NodeData;
import nl.aurorion.blockregen.xseries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockRegenPluginImpl
extends JavaPlugin
implements Listener,
BlockRegenPlugin {
    @Generated
    private static final Logger log = Logger.getLogger(BlockRegenPluginImpl.class.getName());
    private static final String PACKAGE_NAME = BlockRegenPluginImpl.class.getPackage().getName();
    private static BlockRegenPlugin instance;
    private final Random random = new Random();
    public String newVersion = null;
    private boolean usePlaceholderAPI = false;
    private boolean finishedLoading = false;
    private final VersionManager versionManager = new VersionManagerImpl(this);
    private final Files files = new Files(this);
    private final PresetManager presetManager = new PresetManager(this);
    private final ParticleManager particleManager = new ParticleManager();
    private final RegenerationManager regenerationManager = new RegenerationManager(this);
    private final RegionManager regionManager = new RegionManager(this);
    private final EventManager eventManager = new EventManager(this);
    private final MaterialManager materialManager = new MaterialManager(this);
    private final ItemManager itemManager = new ItemManager(this);
    private final CompatibilityManager compatibilityManager = new CompatibilityManager(this);
    private final RegenerationListener regenerationListener = new RegenerationListener(this);
    private final PhysicsListener physicsListener = new PhysicsListener(this);
    private GsonHelper gsonHelper;
    private ConsoleHandler consoleHandler;

    public static BlockRegenPlugin getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        this.setupLogger();
        this.files.load();
        this.configureLogger();
        log.info("Running on version " + this.versionManager.getVersion());
        this.versionManager.load();
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeHierarchyAdapter(NodeData.class, new NodeDataAdapter()).registerTypeAdapter((Type)((Object)NodeData.class), new NodeDataInstanceCreator(this.versionManager.getNodeProvider())).setPrettyPrinting();
        this.gsonHelper = new GsonHelper(gsonBuilder);
        this.particleManager.addParticle("fireworks", new FireWorks());
        this.particleManager.addParticle("flame_crown", new FlameCrown());
        this.particleManager.addParticle("witch_spell", new WitchSpell());
        this.particleManager.addParticle("fire_cube", new FireCube());
        Message.load();
        this.materialManager.registerParser(null, new MinecraftMaterialParser(this));
        this.materialManager.registerParser("minecraft", new MinecraftMaterialParser(this));
        DefaultConditions.all().forEach(pair -> this.presetManager.getConditions().addProvider((String)pair.getFirst(), (GenericConditionProvider.ProviderEntry)pair.getSecond()));
        this.checkPlaceholderAPI();
        this.compatibilityManager.discover(false);
        this.presetManager.load();
        this.regionManager.load();
        this.regenerationManager.load();
        this.finishedLoading = true;
        this.registerListeners();
        Objects.requireNonNull(this.getCommand("blockregen")).setExecutor((CommandExecutor)new Commands(this));
        String ver = this.getDescription().getVersion();
        log.info("&bYou are using" + (ver.contains("-SNAPSHOT") || ver.contains("-b") ? " &cDEVELOPMENT&b" : "") + " version &f" + this.getDescription().getVersion());
        log.info("&bReport bugs or suggestions to discord only please. &f( /blockregen discord )");
        log.info("&bAlways backup if you are not sure about things.");
        this.enableMetrics();
        if (this.getConfig().getBoolean("Update-Checker", false)) {
            this.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this, () -> {
                UpdateCheck updater = new UpdateCheck(this, 9885);
                try {
                    if (updater.checkForUpdates()) {
                        this.newVersion = updater.getLatestVersion();
                    }
                }
                catch (Exception e) {
                    log.warning("Could not check for updates.");
                }
            }, 20L);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            this.compatibilityManager.discover(!this.presetManager.isRetry());
            this.presetManager.reattemptLoad();
            this.regenerationManager.reattemptLoad();
            this.regionManager.reattemptLoad();
            if (this.getConfig().getBoolean("Auto-Save.Enabled", false)) {
                this.regenerationManager.startAutoSave();
            }
        }, 1L);
    }

    @Override
    public void reload(CommandSender sender) {
        if (!(sender instanceof ConsoleCommandSender)) {
            this.consoleHandler.addListener(sender);
        }
        this.eventManager.disableAll();
        this.eventManager.clearBars();
        this.versionManager.load();
        this.compatibilityManager.discover(false);
        this.checkPlaceholderAPI();
        this.files.getSettings().load();
        this.configureLogger();
        this.files.getMessages().load();
        Message.load();
        this.files.getBlockList().load();
        this.presetManager.load();
        this.physicsListener.load();
        this.regionManager.reload();
        if (this.getConfig().getBoolean("Auto-Save.Enabled", false)) {
            this.regenerationManager.reloadAutoSave();
        }
        this.consoleHandler.removeListener(sender);
        Message.RELOAD.optional().ifPresent(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
    }

    public void onDisable() {
        if (this.regenerationManager.getAutoSaveTask() != null) {
            this.regenerationManager.getAutoSaveTask().stop();
        }
        if (this.finishedLoading) {
            this.regenerationManager.revertAll();
            this.regenerationManager.save(true);
            this.regionManager.save();
        }
        this.teardownLogger();
    }

    private void registerListeners() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)this.regenerationListener, (Plugin)this);
        if (this.versionManager.isCurrentAbove("1.13.2", true)) {
            this.physicsListener.load();
            pluginManager.registerEvents((Listener)this.physicsListener, (Plugin)this);
        } else if (!this.getConfig().isSet("Disable-Physics") || this.getConfig().getBoolean("Disable-Physics", false)) {
            log.warning("Option `Disable-Physics` has no effect on versions below 1.13.2.");
        }
        pluginManager.registerEvents((Listener)new PlayerListener(this), (Plugin)this);
    }

    private void checkPlaceholderAPI() {
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI") && !this.usePlaceholderAPI) {
            this.usePlaceholderAPI = true;
            log.info("Found PlaceholderAPI! &aUsing it for placeholders.");
        }
    }

    public void enableMetrics() {
        new MetricsLite(this);
        log.info("&8MetricsLite enabled");
    }

    private static Logger getParentLogger() {
        return Logger.getLogger(PACKAGE_NAME);
    }

    private void setupLogger() {
        Logger parentLogger = BlockRegenPluginImpl.getParentLogger();
        this.consoleHandler = new ConsoleHandler(this);
        parentLogger.setUseParentHandlers(false);
        parentLogger.addHandler(this.consoleHandler);
    }

    private void configureLogger() {
        this.consoleHandler.setPrefix(Message.PREFIX.getValue());
        boolean debug = this.files.getSettings().getFileConfiguration().getBoolean("Debug-Enabled", false);
        this.setLogLevel(debug ? Level.FINE : Level.INFO);
    }

    private void teardownLogger() {
        Logger parentLogger = BlockRegenPluginImpl.getParentLogger();
        parentLogger.removeHandler(this.consoleHandler);
        parentLogger.setLevel(Level.INFO);
        this.consoleHandler = null;
    }

    @Override
    @Nullable
    public XMaterial getBlockType(@NotNull Block block) {
        try {
            return this.getVersionManager().getMethods().getType(block);
        }
        catch (IllegalArgumentException e) {
            log.fine(() -> "Unknown material " + block.getType());
            if (!this.getConfig().getBoolean("Ignore-Unknown-Materials", false)) {
                throw e;
            }
            return null;
        }
    }

    @Override
    @NotNull
    public Level getLogLevel() {
        return BlockRegenPluginImpl.getParentLogger().getLevel();
    }

    @Override
    public void setLogLevel(@NotNull Level level) {
        Logger parentLogger = BlockRegenPluginImpl.getParentLogger();
        parentLogger.setLevel(level);
    }

    @Override
    @NotNull
    public FileConfiguration getConfig() {
        return this.files.getSettings().getFileConfiguration();
    }

    @Override
    @Generated
    public Random getRandom() {
        return this.random;
    }

    @Override
    @Generated
    public boolean isUsePlaceholderAPI() {
        return this.usePlaceholderAPI;
    }

    @Override
    @Generated
    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    @Override
    @Generated
    public Files getFiles() {
        return this.files;
    }

    @Override
    @Generated
    public PresetManager getPresetManager() {
        return this.presetManager;
    }

    @Override
    @Generated
    public ParticleManager getParticleManager() {
        return this.particleManager;
    }

    @Override
    @Generated
    public RegenerationManager getRegenerationManager() {
        return this.regenerationManager;
    }

    @Override
    @Generated
    public RegionManager getRegionManager() {
        return this.regionManager;
    }

    @Override
    @Generated
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    @Generated
    public MaterialManager getMaterialManager() {
        return this.materialManager;
    }

    @Override
    @Generated
    public ItemManager getItemManager() {
        return this.itemManager;
    }

    @Override
    @Generated
    public CompatibilityManager getCompatibilityManager() {
        return this.compatibilityManager;
    }

    @Generated
    public RegenerationListener getRegenerationListener() {
        return this.regenerationListener;
    }

    @Generated
    public PhysicsListener getPhysicsListener() {
        return this.physicsListener;
    }

    @Override
    @Generated
    public GsonHelper getGsonHelper() {
        return this.gsonHelper;
    }

    @Override
    @Generated
    public ConsoleHandler getConsoleHandler() {
        return this.consoleHandler;
    }
}

