/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen;

import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import lombok.Generated;
import nl.aurorion.blockregen.util.Colors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ConsoleHandler
extends Handler {
    private static final String NORMAL_PATTERN = "%s&r%s: %s";
    private final JavaPlugin plugin;
    private final ConsoleCommandSender console;
    private String prefix = "";
    private final Set<CommandSender> listeners = new HashSet<CommandSender>();

    protected ConsoleHandler(JavaPlugin plugin) {
        this.plugin = plugin;
        this.console = plugin.getServer().getConsoleSender();
    }

    @Override
    public void publish(LogRecord record) {
        String levelName = String.format("&7%s", record.getLevel().getName());
        if (record.getLevel().intValue() < Level.INFO.intValue()) {
            levelName = "&eDEBUG";
        } else if (record.getLevel().intValue() > Level.INFO.intValue()) {
            levelName = "&c" + record.getLevel().getName();
        }
        String message = String.format(NORMAL_PATTERN, this.prefix, levelName, record.getMessage());
        this.sendRaw(record, message);
    }

    private void sendRaw(LogRecord record, String msg) {
        if (Strings.isNullOrEmpty((String)msg)) {
            return;
        }
        String coloredMessage = Colors.color(msg);
        this.toListeners(coloredMessage);
        if (this.console == null) {
            Bukkit.getLogger().log(record.getLevel(), Colors.stripColor(msg));
        } else {
            this.console.sendMessage(coloredMessage);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    public void addListener(@NotNull CommandSender listener) {
        this.listeners.add(listener);
    }

    public void removeListener(@NotNull CommandSender listener) {
        this.listeners.remove(listener);
    }

    public void toListeners(String message) {
        if (message != null) {
            this.listeners.forEach(c -> c.sendMessage(message));
        }
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix == null ? "" : prefix;
    }

    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public Set<CommandSender> getListeners() {
        return this.listeners;
    }
}

