/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen;

import com.google.common.base.Strings;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.json.gson.Gson;
import nl.aurorion.blockregen.json.gson.GsonBuilder;
import nl.aurorion.blockregen.json.gson.reflect.TypeToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GsonHelper {
    @Generated
    private static final Logger log = Logger.getLogger(GsonHelper.class.getName());
    private final Gson gson;

    public GsonHelper(GsonBuilder gsonBuilder) {
        this.gson = gsonBuilder.create();
    }

    public GsonHelper(boolean prettyPrinting) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        if (prettyPrinting) {
            gsonBuilder.setPrettyPrinting();
        }
        this.gson = gsonBuilder.create();
    }

    public GsonHelper() {
        this(false);
    }

    public static <T> Type mapList(@NotNull Class<T> innerType) {
        return TypeToken.getParameterized(List.class, new Type[]{innerType}).getType();
    }

    public static <T> Type map(@NotNull Class<T> clazz) {
        return new TypeToken<T>(){}.getType();
    }

    @NotNull
    public CompletableFuture<ByteBuffer> read(@NotNull Path path) {
        long size;
        AsynchronousFileChannel channel;
        try {
            channel = AsynchronousFileChannel.open(path, StandardOpenOption.READ);
            size = channel.size();
        }
        catch (IOException e) {
            log.severe("Could not open an asynchronous file channel.");
            e.printStackTrace();
            return CompletableFuture.supplyAsync(() -> {
                throw new CompletionException(e);
            });
        }
        if (size > Integer.MAX_VALUE) {
            return CompletableFuture.supplyAsync(() -> {
                throw new CompletionException(new IllegalStateException("File is too big for the reader."));
            });
        }
        final ByteBuffer buffer = ByteBuffer.allocate((int)size);
        final CompletableFuture<ByteBuffer> future = new CompletableFuture<ByteBuffer>();
        channel.read(buffer, 0L, future, new CompletionHandler<Integer, CompletableFuture<ByteBuffer>>(){

            @Override
            public void completed(Integer result, CompletableFuture<ByteBuffer> attachment) {
                future.complete(buffer);
            }

            @Override
            public void failed(Throwable exc, CompletableFuture<ByteBuffer> attachment) {
                future.completeExceptionally(exc);
            }
        });
        return future;
    }

    @Nullable
    public <T> T load(@NotNull String dataPath, @NotNull Type type) {
        String input;
        Path path = Paths.get(dataPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            input = String.join((CharSequence)"", Files.readAllLines(path));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (Strings.isNullOrEmpty((String)input)) {
            return null;
        }
        return this.gson.fromJson(input, type);
    }

    @NotNull
    public <T> CompletableFuture<List<T>> loadListAsync(@NotNull String dataPath, @NotNull Class<T> innerClazz) {
        Path path = Paths.get(dataPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return new CompletableFuture<List<T>>();
        }
        Type type = GsonHelper.mapList(innerClazz);
        return this.read(path).thenApplyAsync(buffer -> {
            String output = new String(buffer.array(), StandardCharsets.UTF_8).trim();
            if (Strings.isNullOrEmpty((String)output)) {
                return null;
            }
            return (List)this.gson.fromJson(output, type);
        });
    }

    @NotNull
    public <T> CompletableFuture<Void> save(@NotNull T input, @NotNull String dataPath) {
        Path path = Paths.get(dataPath, new String[0]);
        Type type = GsonHelper.map(input.getClass());
        return CompletableFuture.runAsync(() -> {
            String jsonString = this.gson.toJson(input, type).trim();
            try {
                Files.write(path, jsonString.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

