/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.compatibility.impl;

import io.lumine.mythic.lib.api.item.NBTItem;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.block.CustomBlock;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.ParseException;
import nl.aurorion.blockregen.compatibility.CompatibilityProvider;
import nl.aurorion.blockregen.conditional.Condition;
import nl.aurorion.blockregen.material.BlockRegenMaterial;
import nl.aurorion.blockregen.material.MMOIItemsMaterial;
import nl.aurorion.blockregen.material.parser.MaterialParser;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MMOItemsProvider
extends CompatibilityProvider
implements MaterialParser {
    private static final Pattern ITEM_PATTERN = Pattern.compile("(\\S+):(\\S+)");

    public MMOItemsProvider(BlockRegenPlugin plugin) {
        super(plugin, "mmoitems");
        this.setFeatures("materials", "conditions");
    }

    @Override
    public void onLoad() {
        this.plugin.getPresetManager().getConditions().addProvider(this.getPrefix() + "/tool", (key, node) -> {
            Matcher matcher = ITEM_PATTERN.matcher((String)node);
            if (!matcher.matches()) {
                throw new ParseException("Invalid input for MMOItems tool. Has to have the format of <type>:<id>.");
            }
            String typeName = matcher.group(1);
            Type type = MMOItems.plugin.getTypes().get(typeName);
            if (type == null) {
                throw new ParseException("Invalid MMOItems item type " + typeName + ".");
            }
            String id = matcher.group(2);
            MMOItem item = MMOItems.plugin.getMMOItem(type, id);
            if (item == null) {
                throw new ParseException("Invalid MMOItems item '" + type + ":" + id + "'.");
            }
            return Condition.of(ctx -> {
                ItemStack tool = (ItemStack)ctx.mustVar("tool");
                NBTItem nbtItem = NBTItem.get((ItemStack)tool);
                if (nbtItem == null) {
                    return false;
                }
                if (!nbtItem.hasType() || !nbtItem.hasTag("MMOITEMS_ITEM_ID")) {
                    return false;
                }
                String toolType = nbtItem.getType();
                if (!toolType.equalsIgnoreCase(typeName)) {
                    return false;
                }
                String toolId = nbtItem.getString("MMOITEMS_ITEM_ID");
                return toolId.equalsIgnoreCase(id);
            });
        });
    }

    @Override
    @NotNull
    public BlockRegenMaterial parseMaterial(String input) {
        int id;
        try {
            id = Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            throw new ParseException(String.format("Invalid MMOItem block id: '%s'.", input));
        }
        CustomBlock customBlock = MMOItems.plugin.getCustomBlocks().getBlock(id);
        if (customBlock == null) {
            throw new ParseException("Invalid MMOItems block '" + input + "'");
        }
        return new MMOIItemsMaterial(this.plugin, id);
    }
}

