/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.conditional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import nl.aurorion.blockregen.conditional.Condition;
import nl.aurorion.blockregen.conditional.ConditionContext;
import nl.aurorion.blockregen.conditional.ConditionRelation;
import org.jetbrains.annotations.NotNull;

public class ComposedCondition
extends Condition {
    private final List<Condition> conditions = new ArrayList<Condition>();
    private final ConditionRelation relation;
    private String defaultAlias;

    ComposedCondition(ConditionRelation relation, Condition ... conditions) {
        this.relation = relation;
        this.conditions.addAll(Arrays.asList(conditions));
        this.defaultAlias = this.createAlias();
    }

    ComposedCondition(ConditionRelation relation, List<Condition> conditions) {
        this.relation = relation;
        this.conditions.addAll(conditions);
        this.defaultAlias = this.createAlias();
    }

    public void append(Condition condition) {
        this.conditions.add(condition);
        this.defaultAlias = this.createAlias();
    }

    @Override
    public boolean match(ConditionContext context) {
        if (this.relation == ConditionRelation.AND) {
            for (Condition condition : this.conditions) {
                if (condition.matches(context)) continue;
                return false;
            }
            return true;
        }
        if (this.relation == ConditionRelation.OR) {
            for (Condition condition : this.conditions) {
                if (!condition.matches(context)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    @NotNull
    public String alias() {
        return this.getAlias() == null ? this.defaultAlias : this.getAlias();
    }

    private String createAlias() {
        String c = this.conditions.stream().map(Condition::alias).collect(Collectors.joining(" " + this.relation.toString().toLowerCase() + " "));
        return this.conditions.size() < 2 ? c : "(" + c + ")";
    }

    @Generated
    public ConditionRelation getRelation() {
        return this.relation;
    }
}

