/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.configuration;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigFile {
    @Generated
    private static final Logger log = Logger.getLogger(ConfigFile.class.getName());
    private final String path;
    private FileConfiguration fileConfiguration;
    private File file;
    private final BlockRegenPlugin plugin;

    public ConfigFile(BlockRegenPlugin plugin, String path) {
        this.path = path.contains(".yml") ? path : path + ".yml";
        this.plugin = plugin;
    }

    public void load() {
        this.file = new File(this.plugin.getDataFolder(), this.path);
        if (!this.file.exists()) {
            try {
                this.plugin.saveResource(this.path, false);
            }
            catch (IllegalArgumentException e) {
                try {
                    if (!this.file.createNewFile()) {
                        log.severe("Could not create file " + this.path);
                    }
                }
                catch (IOException e1) {
                    log.severe("Could not create file " + this.path);
                    return;
                }
            }
            log.info("Created file " + this.path);
        }
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        log.info("Loaded file " + this.path);
    }

    public void save() {
        try {
            this.fileConfiguration.save(this.file);
        }
        catch (IOException e) {
            log.severe("Could not save " + this.path);
        }
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public FileConfiguration getFileConfiguration() {
        return this.fileConfiguration;
    }

    @Generated
    public File getFile() {
        return this.file;
    }
}

