/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.listener;

import java.util.List;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.regeneration.struct.RegenerationProcess;
import nl.aurorion.blockregen.region.struct.RegenerationArea;
import nl.aurorion.blockregen.util.Blocks;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;

public class PhysicsListener
implements Listener {
    @Generated
    private static final Logger log = Logger.getLogger(PhysicsListener.class.getName());
    private final BlockRegenPlugin plugin;
    private boolean disablePhysics;
    private boolean useRegions;
    private List<String> worldsEnabled;

    public PhysicsListener(BlockRegenPlugin plugin) {
        this.plugin = plugin;
    }

    public void load() {
        this.disablePhysics = !this.plugin.getConfig().isSet("Disable-Physics") || this.plugin.getConfig().getBoolean("Disable-Physics", false);
        this.useRegions = this.plugin.getConfig().getBoolean("Use-Regions");
        this.worldsEnabled = this.plugin.getConfig().getStringList("Worlds-Enabled");
    }

    @EventHandler
    public void onPhysics(BlockPhysicsEvent event) {
        boolean isInZone;
        if (!this.disablePhysics) {
            return;
        }
        Block block = event.getBlock();
        World world = block.getWorld();
        boolean useRegions = this.useRegions;
        RegenerationArea region = this.plugin.getRegionManager().getArea(block);
        boolean isInWorld = this.worldsEnabled.contains(world.getName());
        boolean isInRegion = region != null;
        boolean bl = isInZone = useRegions ? isInRegion : isInWorld;
        if (!isInZone) {
            return;
        }
        RegenerationProcess process = this.plugin.getRegenerationManager().getProcess(event.getSourceBlock());
        if (process == null || !process.getPreset().isDisablePhysics()) {
            return;
        }
        event.setCancelled(true);
        log.fine(() -> event.getChangedType() + " " + Blocks.blockToString(event.getBlock()));
    }
}

