/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.material.parser;

import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.material.BlockRegenMaterial;
import nl.aurorion.blockregen.material.MinecraftMaterial;
import nl.aurorion.blockregen.material.parser.MaterialParser;
import nl.aurorion.blockregen.util.Parsing;
import nl.aurorion.blockregen.version.api.NodeData;
import nl.aurorion.blockregen.xseries.XMaterial;
import org.jetbrains.annotations.NotNull;

public class MinecraftMaterialParser
implements MaterialParser {
    @Generated
    private static final Logger log = Logger.getLogger(MinecraftMaterialParser.class.getName());
    private final BlockRegenPlugin plugin;

    public MinecraftMaterialParser(BlockRegenPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public BlockRegenMaterial parseMaterial(String input) {
        log.fine(() -> String.format("Parsing MC material from %s", input));
        boolean loadData = false;
        String materialPart = input;
        if (input.contains("[")) {
            materialPart = input.substring(0, input.indexOf("["));
            loadData = true;
        }
        XMaterial xMaterial = Parsing.parseMaterial(materialPart, this.plugin.getVersionManager().isCurrentAbove("1.12.2", false));
        if (loadData) {
            NodeData nodeData = this.plugin.getVersionManager().getNodeDataParser().parse(String.format("minecraft:%s", input));
            return new MinecraftMaterial(this.plugin, xMaterial, nodeData);
        }
        return new MinecraftMaterial(this.plugin, xMaterial);
    }
}

