/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.particle;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.particle.Particle;
import nl.aurorion.blockregen.util.Locations;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;

public class ParticleManager {
    @Generated
    private static final Logger log = Logger.getLogger(ParticleManager.class.getName());
    private final Map<String, Particle> particles = new HashMap<String, Particle>();

    public void displayParticle(@NotNull String particleName, @NotNull Block block) {
        Location location = block.getLocation();
        if (!this.particles.containsKey(particleName)) {
            return;
        }
        this.particles.get(particleName).display(location);
        log.fine(() -> "Displayed particle " + particleName + " at location " + Locations.locationToString(location));
    }

    public void addParticle(String name, Particle particle) {
        this.particles.put(name, particle);
    }

    public Map<String, Particle> getParticles() {
        return Collections.unmodifiableMap(this.particles);
    }

    public Particle getParticle(String name) {
        return this.particles.getOrDefault(name, null);
    }
}

