/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.preset.condition;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import nl.aurorion.blockregen.ParseException;
import nl.aurorion.blockregen.conditional.ComposedCondition;
import nl.aurorion.blockregen.conditional.Condition;
import nl.aurorion.blockregen.preset.condition.ConditionProvider;
import nl.aurorion.blockregen.preset.condition.ConditionRelation;
import nl.aurorion.blockregen.preset.condition.Conditions;
import nl.aurorion.blockregen.preset.condition.ContextExtender;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericConditionProvider
implements ConditionProvider {
    @Generated
    private static final Logger log = Logger.getLogger(GenericConditionProvider.class.getName());
    private final Map<String, ProviderEntry> providers;
    @Nullable
    private ContextExtender extender;

    GenericConditionProvider(Map<String, ProviderEntry> providers, @Nullable ContextExtender extender) {
        this.providers = new HashMap<String, ProviderEntry>(providers);
        this.extender = extender;
    }

    public Map<String, ProviderEntry> getProviders() {
        return Collections.unmodifiableMap(this.providers);
    }

    @NotNull
    public static GenericConditionProvider singleNode(@NotNull String key, @NotNull ProviderEntry entry) {
        return new GenericConditionProvider(Collections.singletonMap(key, entry), null);
    }

    @NotNull
    public static GenericConditionProvider singleNode(@NotNull String key, @NotNull ProviderEntry entry, @Nullable ContextExtender extender) {
        return new GenericConditionProvider(Collections.singletonMap(key, entry), extender);
    }

    @NotNull
    public static GenericConditionProvider singleNode(@NotNull String key, @NotNull ConditionProvider provider, @Nullable ContextExtender extender) {
        return new GenericConditionProvider(Collections.singletonMap(key, ProviderEntry.of(provider)), extender);
    }

    @NotNull
    public static GenericConditionProvider singleNode(@NotNull String key, @NotNull ConditionProvider provider) {
        return new GenericConditionProvider(Collections.singletonMap(key, ProviderEntry.of(provider)), null);
    }

    @NotNull
    public static GenericConditionProvider empty() {
        return new GenericConditionProvider(Collections.emptyMap(), null);
    }

    @NotNull
    public GenericConditionProvider addProvider(@NotNull String key, @NotNull ProviderEntry entry) {
        this.providers.put(key, entry);
        return this;
    }

    @NotNull
    public GenericConditionProvider addProvider(@NotNull String key, @NotNull ConditionProvider provider) {
        this.providers.put(key, ProviderEntry.of(provider));
        return this;
    }

    @NotNull
    public GenericConditionProvider extender(@Nullable ContextExtender extender) {
        this.extender = extender;
        return this;
    }

    @Override
    @NotNull
    public Condition load(@Nullable String key, @NotNull Object node) {
        Condition condition;
        ProviderEntry entry = this.providers.get(key);
        if (entry == null) {
            throw new ParseException("Invalid property '" + key + "'");
        }
        if (!(node instanceof ConfigurationSection || node instanceof List || entry.isApplicable(node.getClass()))) {
            throw new ParseException("Invalid property type '" + node.getClass().getSimpleName() + "' for '" + key + "'. Required: " + Arrays.stream(entry.getExpectedClasses()).map(Class::getSimpleName).collect(Collectors.joining(",")));
        }
        try {
            condition = Conditions.fromNode(node, entry.getRelation(), entry.getProvider());
            log.fine(String.valueOf(condition instanceof ComposedCondition));
            log.fine(condition.getAlias());
            log.fine(key);
            if (!(condition instanceof ComposedCondition) && condition.getAlias() == null) {
                condition.alias(key);
            }
        }
        catch (ParseException e) {
            throw new ParseException("Failed to parse '" + key + "': " + e.getMessage(), e);
        }
        return this.extender == null ? condition : Conditions.wrap(condition, this.extender);
    }

    public static class ProviderEntry {
        private final ConditionProvider provider;
        private final Class<?>[] expectedClasses;
        private final ConditionRelation relation;

        @NotNull
        public static ProviderEntry of(@NotNull ConditionProvider provider, Class<?> ... expectedClasses) {
            return new ProviderEntry(provider, expectedClasses, ConditionRelation.OR);
        }

        @NotNull
        public static ProviderEntry of(@NotNull ConditionProvider provider, @NotNull ConditionRelation relation, Class<?> ... expectedClasses) {
            return new ProviderEntry(provider, expectedClasses, relation);
        }

        @NotNull
        public static ProviderEntry of(@NotNull ConditionProvider provider) {
            return ProviderEntry.of(provider, Object.class);
        }

        @NotNull
        public static ProviderEntry of(@NotNull ConditionProvider provider, @NotNull ConditionRelation relation) {
            return ProviderEntry.of(provider, relation, Object.class);
        }

        private boolean isApplicable(Class<?> nodeClazz) {
            for (Class<?> clazz : this.expectedClasses) {
                if (!clazz.isAssignableFrom(nodeClazz)) continue;
                return true;
            }
            return false;
        }

        @Generated
        public ConditionProvider getProvider() {
            return this.provider;
        }

        @Generated
        public Class<?>[] getExpectedClasses() {
            return this.expectedClasses;
        }

        @Generated
        public ConditionRelation getRelation() {
            return this.relation;
        }

        @Generated
        private ProviderEntry(ConditionProvider provider, Class<?>[] expectedClasses, ConditionRelation relation) {
            this.provider = provider;
            this.expectedClasses = expectedClasses;
            this.relation = relation;
        }
    }
}

