/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.regeneration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.AutoSaveTask;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.preset.BlockPreset;
import nl.aurorion.blockregen.regeneration.struct.RegenerationProcess;
import nl.aurorion.blockregen.region.struct.RegenerationArea;
import nl.aurorion.blockregen.version.api.NodeData;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegenerationManager {
    @Generated
    private static final Logger log = Logger.getLogger(RegenerationManager.class.getName());
    private final BlockRegenPlugin plugin;
    private final Map<Block, RegenerationProcess> cache = new ConcurrentHashMap<Block, RegenerationProcess>();
    private AutoSaveTask autoSaveTask;
    private boolean retry = false;
    private final Set<UUID> bypass = new HashSet<UUID>();
    private final Set<UUID> dataCheck = new HashSet<UUID>();

    public RegenerationManager(BlockRegenPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean hasBypass(@NotNull Player player) {
        return this.bypass.contains(player.getUniqueId());
    }

    public boolean switchBypass(@NotNull Player player) {
        if (this.bypass.contains(player.getUniqueId())) {
            this.bypass.remove(player.getUniqueId());
            return false;
        }
        this.bypass.add(player.getUniqueId());
        return true;
    }

    public boolean hasDataCheck(@NotNull Player player) {
        return this.dataCheck.contains(player.getUniqueId());
    }

    public boolean switchDataCheck(@NotNull Player player) {
        if (this.dataCheck.contains(player.getUniqueId())) {
            this.dataCheck.remove(player.getUniqueId());
            return false;
        }
        this.dataCheck.add(player.getUniqueId());
        return true;
    }

    @NotNull
    public RegenerationProcess createProcess(@NotNull Block block, @NotNull BlockPreset preset, @Nullable RegenerationArea region) {
        Objects.requireNonNull(block);
        Objects.requireNonNull(preset);
        NodeData nodeData = this.plugin.getVersionManager().createNodeData();
        nodeData.load(block);
        RegenerationProcess process = new RegenerationProcess(block, nodeData, preset);
        process.setWorldName(block.getWorld().getName());
        if (region != null) {
            process.setRegionName(region.getName());
        }
        return process;
    }

    public void registerProcess(@NotNull RegenerationProcess process) {
        Objects.requireNonNull(process);
        if (this.getProcess(process.getBlock()) != null) {
            log.fine(() -> String.format("Cache already contains process %s", process.getId()));
            return;
        }
        this.cache.put(process.getBlock(), process);
        log.fine(() -> "Registered regeneration process " + process);
    }

    @Nullable
    public RegenerationProcess getProcess(@NotNull Block block) {
        return this.cache.get(block);
    }

    public boolean isRegenerating(@NotNull Block block) {
        RegenerationProcess process = this.getProcess(block);
        return process != null && process.getRegenerationTime() > System.currentTimeMillis();
    }

    public void removeProcess(RegenerationProcess process) {
        if (this.cache.remove(process.getBlock()) != null) {
            log.fine(() -> String.format("Removed process from cache: %s", process));
        } else {
            log.fine(() -> String.format("Process %s not found, not removed.", process));
        }
    }

    public void removeProcess(@NotNull Block block) {
        this.cache.remove(block);
    }

    public void startAutoSave() {
        this.autoSaveTask = new AutoSaveTask(this.plugin);
        this.autoSaveTask.load();
        this.autoSaveTask.start();
    }

    public void reloadAutoSave() {
        if (this.autoSaveTask == null) {
            this.startAutoSave();
        } else {
            this.autoSaveTask.stop();
            this.autoSaveTask.load();
            this.autoSaveTask.start();
        }
    }

    public void revertAll() {
        this.cache.values().forEach(RegenerationProcess::revertBlock);
    }

    private void purgeExpired() {
        for (RegenerationProcess process : this.cache.values()) {
            if (process.getTimeLeft() >= 0L || !process.shouldRegenerate()) continue;
            if (Bukkit.isPrimaryThread()) {
                process.regenerateBlock();
                continue;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, process::regenerateBlock);
        }
    }

    public void save() {
        this.save(false);
    }

    public void save(boolean sync) {
        this.cache.values().forEach(process -> process.setTimeLeft(process.getRegenerationTime() - System.currentTimeMillis()));
        this.purgeExpired();
        ArrayList<RegenerationProcess> finalCache = new ArrayList<RegenerationProcess>(this.cache.values());
        CompletionStage future = this.plugin.getGsonHelper().save(finalCache, this.plugin.getDataFolder().getPath() + "/Data.json").exceptionally(e -> {
            log.severe("Could not save processes: " + e.getMessage());
            e.printStackTrace();
            return null;
        });
        if (sync) {
            ((CompletableFuture)future).join();
        }
        log.info("Saved " + finalCache.size() + " regeneration processes..");
    }

    public void load() {
        ((CompletableFuture)this.plugin.getGsonHelper().loadListAsync(this.plugin.getDataFolder().getPath() + "/Data.json", RegenerationProcess.class).thenAcceptAsync(loadedProcesses -> {
            this.cache.clear();
            if (loadedProcesses == null) {
                return;
            }
            for (RegenerationProcess process : loadedProcesses) {
                if (process == null) {
                    log.warning("Failed to load a process from storage. Report this to the maintainer of the plugin.");
                    continue;
                }
                if (!process.convertLocation()) {
                    this.retry = true;
                    log.warning("Failed to prepare process '" + process.getPresetName() + "'.");
                    break;
                }
                if (!process.convertPreset()) {
                    this.retry = true;
                    log.warning("Failed to prepare process '" + process.getPresetName() + "'.");
                    break;
                }
                log.fine(() -> "Prepared regeneration process " + process);
            }
            if (!this.retry) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    loadedProcesses.forEach(RegenerationProcess::start);
                    log.info("Loaded " + this.cache.size() + " regeneration process(es)...");
                });
            } else {
                log.info("Some processes couldn't load, trying again after a complete server load.");
            }
        })).exceptionally(e -> {
            log.severe("Could not load processes: " + e.getMessage());
            e.printStackTrace();
            return null;
        });
    }

    public void reattemptLoad() {
        if (!this.retry) {
            return;
        }
        this.load();
        this.retry = false;
    }

    @NotNull
    public Collection<RegenerationProcess> getCache() {
        return Collections.unmodifiableCollection(this.cache.values());
    }

    @Generated
    public AutoSaveTask getAutoSaveTask() {
        return this.autoSaveTask;
    }
}

