/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.region;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.preset.BlockPreset;
import nl.aurorion.blockregen.region.RegionSelection;
import nl.aurorion.blockregen.region.struct.RawRegion;
import nl.aurorion.blockregen.region.struct.RegenerationArea;
import nl.aurorion.blockregen.region.struct.RegenerationRegion;
import nl.aurorion.blockregen.region.struct.RegenerationWorld;
import nl.aurorion.blockregen.util.Locations;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegionManager {
    @Generated
    private static final Logger log = Logger.getLogger(RegionManager.class.getName());
    private final BlockRegenPlugin plugin;
    private final List<RegenerationArea> loadedAreas = new ArrayList<RegenerationArea>();
    private final Set<RawRegion> failedRegions = new HashSet<RawRegion>();
    private final Map<UUID, RegionSelection> selections = new HashMap<UUID, RegionSelection>();

    public RegionManager(BlockRegenPlugin plugin) {
        this.plugin = plugin;
    }

    public void sort() {
        this.loadedAreas.sort((o1, o2) -> Comparator.comparing(RegenerationArea::getPriority).reversed().compare((RegenerationArea)o1, (RegenerationArea)o2));
    }

    public boolean isSelecting(@NotNull Player player) {
        return this.selections.containsKey(player.getUniqueId());
    }

    public RegionSelection getSelection(@NotNull Player player) {
        return this.selections.get(player.getUniqueId());
    }

    @NotNull
    public RegionSelection getOrCreateSelection(@NotNull Player player) {
        RegionSelection selection = this.selections.get(player.getUniqueId());
        if (selection == null) {
            selection = new RegionSelection();
            this.selections.put(player.getUniqueId(), selection);
        }
        return selection;
    }

    @NotNull
    public RegenerationRegion createRegion(@NotNull String name, @NotNull RegionSelection selection) {
        Location first = selection.getFirst();
        Location second = selection.getSecond();
        if (first.getWorld() != second.getWorld()) {
            throw new IllegalStateException("Selection points have to be in the same world.");
        }
        Location min = new Location(first.getWorld(), Math.min(first.getX(), second.getX()), Math.min(first.getY(), second.getY()), Math.min(first.getZ(), second.getZ()));
        Location max = new Location(first.getWorld(), Math.max(first.getX(), second.getX()), Math.max(first.getY(), second.getY()), Math.max(first.getZ(), second.getZ()));
        return new RegenerationRegion(name, min, max);
    }

    public boolean finishSelection(@NotNull String name, @NotNull RegionSelection selection) {
        RegenerationRegion region = this.createRegion(name, selection);
        this.addArea(region);
        return true;
    }

    @NotNull
    public RegenerationWorld createWorld(@NotNull String name, String worldName) {
        return new RegenerationWorld(name, worldName);
    }

    public void reattemptLoad() {
        if (this.failedRegions.isEmpty()) {
            return;
        }
        log.info("Reattempting to load regions...");
        int count = this.failedRegions.size();
        this.failedRegions.removeIf(rawRegion -> rawRegion.isReattempt() && this.loadRegion((RawRegion)rawRegion));
        log.info("Loaded " + (count - this.failedRegions.size()) + " of failed regions.");
    }

    @Nullable
    private RawRegion loadRaw(@NotNull ConfigurationSection section) {
        String name = section.getName();
        String minString = section.getString("Min");
        String maxString = section.getString("Max");
        boolean all = section.getBoolean("All", true);
        List presets = section.getStringList("Presets");
        int priority = section.getInt("Priority", 1);
        RawRegion rawRegion = new RawRegion(name, minString, maxString, presets, all, priority);
        if (Strings.isNullOrEmpty((String)minString) || Strings.isNullOrEmpty((String)maxString)) {
            this.failedRegions.add(rawRegion);
            log.severe("Could not load region " + name + ", invalid location strings.");
            return null;
        }
        if (!Locations.isLocationLoaded(minString) || !Locations.isLocationLoaded(maxString)) {
            rawRegion.setReattempt(true);
            this.failedRegions.add(rawRegion);
            log.info("World for region " + name + " is not loaded. Reattempting after complete server load.");
            return null;
        }
        return rawRegion;
    }

    private void loadWorldRegion(ConfigurationSection section, String name) {
        String worldName = section.getString("worldName");
        RegenerationWorld world = new RegenerationWorld(name, worldName);
        world.setPriority(section.getInt("Priority", 1));
        world.setAll(section.getBoolean("All", true));
        List presets = section.getStringList("Presets");
        for (String presetName : presets) {
            BlockPreset preset = this.plugin.getPresetManager().getPreset(presetName);
            if (preset == null) {
                log.warning(String.format("Preset %s isn't loaded, but is included in region %s.", presetName, world.getName()));
            }
            world.addPreset(presetName);
        }
        log.fine(() -> String.format("Loaded regeneration world %s", world));
        this.loadedAreas.add(world);
    }

    public void load() {
        this.loadedAreas.clear();
        this.plugin.getFiles().getRegions().load();
        FileConfiguration regions = this.plugin.getFiles().getRegions().getFileConfiguration();
        ConfigurationSection parentSection = regions.getConfigurationSection("Regions");
        if (parentSection != null) {
            for (String name : parentSection.getKeys(false)) {
                ConfigurationSection section = parentSection.getConfigurationSection(name);
                if (section == null) continue;
                if (section.isSet("worldName")) {
                    this.loadWorldRegion(section, name);
                    continue;
                }
                RawRegion rawRegion = this.loadRaw(section);
                if (rawRegion == null) continue;
                this.loadRegion(rawRegion);
            }
        }
        this.sort();
        log.info("Loaded " + this.loadedAreas.size() + " region(s)...");
    }

    private boolean loadRegion(RawRegion rawRegion) {
        RegenerationRegion region = rawRegion.build();
        if (region == null) {
            log.warning("Could not load region " + rawRegion.getName() + ", world " + rawRegion.getMax() + " still not loaded.");
            return false;
        }
        for (String presetName : rawRegion.getBlockPresets()) {
            BlockPreset preset = this.plugin.getPresetManager().getPreset(presetName);
            if (preset == null) {
                log.warning(String.format("Preset %s isn't loaded, but is included in region %s.", presetName, rawRegion.getName()));
            }
            region.addPreset(presetName);
        }
        this.loadedAreas.add(region);
        this.sort();
        log.fine(() -> "Loaded region " + region);
        return true;
    }

    public void reload() {
        for (RegenerationArea area : this.loadedAreas) {
            Collection<String> presets = area.getPresets();
            for (String presetName : presets) {
                BlockPreset preset = this.plugin.getPresetManager().getPreset(presetName);
                if (preset != null) continue;
                log.warning(String.format("Preset %s isn't loaded, but is included in area %s.", presetName, area.getName()));
            }
        }
        this.sort();
        log.info("Reloaded " + this.loadedAreas.size() + " region(s)...");
    }

    public void save() {
        FileConfiguration regions = this.plugin.getFiles().getRegions().getFileConfiguration();
        regions.set("Regions", null);
        ConfigurationSection root = this.ensureRegionsSection(regions);
        for (RawRegion rawRegion : new HashSet<RawRegion>(this.failedRegions)) {
            ConfigurationSection regionSection = root.createSection(rawRegion.getName());
            regionSection.set("Min", (Object)rawRegion.getMin());
            regionSection.set("Max", (Object)rawRegion.getMax());
            regionSection.set("All", (Object)rawRegion.isAll());
            regionSection.set("Presets", rawRegion.getBlockPresets());
        }
        for (RegenerationArea area : new HashSet<RegenerationArea>(this.loadedAreas)) {
            ConfigurationSection section = root.createSection(area.getName());
            area.serialize(section);
        }
        this.plugin.getFiles().getRegions().save();
        log.fine(() -> "Saved " + (this.loadedAreas.size() + this.failedRegions.size()) + " area(s)...");
    }

    private ConfigurationSection ensureRegionsSection(FileConfiguration configuration) {
        return configuration.contains("Regions") ? configuration.getConfigurationSection("Regions") : configuration.createSection("Regions");
    }

    public boolean exists(String name) {
        return this.loadedAreas.stream().anyMatch(r -> r.getName().equals(name));
    }

    public RegenerationArea getArea(@NotNull String name) {
        return this.loadedAreas.stream().filter(r -> r.getName().equals(name)).findAny().orElse(null);
    }

    public void removeArea(@NotNull String name) {
        Iterator<RegenerationArea> it = this.loadedAreas.iterator();
        while (it.hasNext()) {
            RegenerationArea area = it.next();
            if (!Objects.equals(area.getName(), name)) continue;
            it.remove();
            break;
        }
        this.sort();
    }

    @Nullable
    public RegenerationArea getArea(@NotNull Block block) {
        for (RegenerationArea area : this.loadedAreas) {
            if (!area.contains(block)) continue;
            return area;
        }
        return null;
    }

    public void addArea(@NotNull RegenerationArea region) {
        this.loadedAreas.add(region);
        this.sort();
        log.fine(() -> "Added area " + region);
        this.save();
    }

    @NotNull
    public List<RegenerationArea> getLoadedAreas() {
        return Collections.unmodifiableList(this.loadedAreas);
    }
}

