/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.region.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RegenerationArea {
    protected final String name;
    protected final Set<String> presets = new HashSet<String>();
    protected boolean all = true;
    protected int priority = 1;

    public RegenerationArea(String name) {
        this.name = name;
    }

    public abstract boolean contains(@NotNull Block var1);

    public void serialize(ConfigurationSection section) {
        section.set("All", (Object)this.all);
        section.set("Presets", new ArrayList<String>(this.presets));
        section.set("Priority", (Object)this.priority);
    }

    public boolean switchAll() {
        this.setAll(!this.isAll());
        return this.isAll();
    }

    public boolean hasPreset(@Nullable String preset) {
        return this.all || preset != null && this.presets.contains(preset);
    }

    public void addPreset(@NotNull String preset) {
        this.presets.add(preset);
    }

    public void removePreset(@NotNull String preset) {
        this.presets.remove(preset);
    }

    public void clearPresets() {
        this.presets.clear();
    }

    @NotNull
    public Collection<String> getPresets() {
        return Collections.unmodifiableCollection(this.presets);
    }

    public String toString() {
        return "RegenerationArea{name='" + this.name + '\'' + ", presets=" + this.presets + ", all=" + this.all + ", priority=" + this.priority + '}';
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setAll(boolean all) {
        this.all = all;
    }

    @Generated
    public boolean isAll() {
        return this.all;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public void setPriority(int priority) {
        this.priority = priority;
    }
}

