/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.util;

import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.util.Locations;
import nl.aurorion.blockregen.xseries.XMaterial;
import org.bukkit.block.Block;

public final class Blocks {
    public static String blockToString(Block block) {
        return "Block{" + Locations.locationToString(block.getLocation()) + ",type=" + block.getType() + "}";
    }

    public static boolean isMultiblockCrop(BlockRegenPlugin plugin, Block block) {
        XMaterial type = plugin.getVersionManager().getMethods().getType(block);
        return Blocks.isMultiblockCrop(type);
    }

    public static boolean isKelp(XMaterial material) {
        return material == XMaterial.KELP || material == XMaterial.KELP_PLANT;
    }

    public static boolean isSeagrass(XMaterial material) {
        return material == XMaterial.SEAGRASS || material == XMaterial.TALL_SEAGRASS;
    }

    public static boolean isMultiblockCrop(XMaterial type) {
        switch (type) {
            case TALL_GRASS: 
            case CACTUS: 
            case BAMBOO: 
            case KELP_PLANT: 
            case KELP: 
            case TALL_SEAGRASS: 
            case SUGAR_CANE: {
                return true;
            }
        }
        return false;
    }

    public static boolean requiresFarmland(XMaterial material) {
        switch (material) {
            case CARROT: 
            case CARROTS: 
            case POTATO: 
            case POTATOES: 
            case PUMPKIN_SEEDS: 
            case WHEAT_SEEDS: 
            case WHEAT: 
            case MELON_SEEDS: 
            case BEETROOT_SEEDS: 
            case BEETROOTS: {
                return true;
            }
        }
        return false;
    }

    public static boolean reliesOnBlockBelow(XMaterial material) {
        if (Blocks.isMultiblockCrop(material)) {
            return true;
        }
        switch (material) {
            case MOSS_CARPET: 
            case SHORT_GRASS: {
                return true;
            }
        }
        return false;
    }

    @Generated
    private Blocks() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

