/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.version.current;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import nl.aurorion.blockregen.util.Serialization;
import nl.aurorion.blockregen.version.api.NodeData;
import nl.aurorion.blockregen.xseries.profiles.builder.XSkull;
import nl.aurorion.blockregen.xseries.profiles.exceptions.InvalidProfileContainerException;
import nl.aurorion.blockregen.xseries.profiles.objects.Profileable;
import org.bukkit.Axis;
import org.bukkit.Instrument;
import org.bukkit.Note;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.NoteBlock;
import org.bukkit.block.data.type.Stairs;

public class LatestNodeData
implements NodeData {
    @Generated
    private static final Logger log = Logger.getLogger(LatestNodeData.class.getName());
    private BlockFace facing;
    private Stairs.Shape stairShape;
    private Axis axis;
    private BlockFace rotation;
    private Integer age;
    private String skull;
    private Boolean waterlogged;
    private Boolean powered;
    private Instrument instrument;
    private Byte noteId;
    private Integer octave;
    private Note.Tone tone;
    private Boolean sharped;
    private final Set<BlockFace> faces = new HashSet<BlockFace>();

    public void addFace(BlockFace face) {
        this.faces.add(face);
    }

    public boolean hasFace(BlockFace face) {
        return this.faces.contains(face);
    }

    @Override
    public boolean matches(Block block) {
        Waterlogged waterlogged;
        Ageable ageable;
        Rotatable rotatable;
        Orientable orientable;
        Stairs stairs;
        Directional directional;
        BlockData data = block.getBlockData();
        log.fine(() -> String.format("Checking %s against block %s", this, data.getAsString()));
        if (this.skull != null && block.getState() instanceof Skull) {
            try {
                String profileString = XSkull.of(block).getDelegateProfile().getProfileValue();
                if (profileString != null && !profileString.equals(this.skull)) {
                    return false;
                }
            }
            catch (InvalidProfileContainerException e) {
                return false;
            }
        }
        if (data instanceof Directional && this.facing != null && (directional = (Directional)data).getFacing() != this.facing) {
            return false;
        }
        if (data instanceof Stairs && this.stairShape != null && (stairs = (Stairs)data).getShape() != this.stairShape) {
            return false;
        }
        if (data instanceof Orientable && this.axis != null && (orientable = (Orientable)data).getAxis() != this.axis) {
            return false;
        }
        if (data instanceof Rotatable && this.rotation != null && (rotatable = (Rotatable)data).getRotation() != this.rotation) {
            return false;
        }
        if (data instanceof Ageable && this.age != null && (ageable = (Ageable)data).getAge() != this.age.intValue()) {
            return false;
        }
        if (data instanceof Waterlogged && this.waterlogged != null && (waterlogged = (Waterlogged)data).isWaterlogged() != this.waterlogged.booleanValue()) {
            return false;
        }
        if (data instanceof NoteBlock) {
            NoteBlock noteBlock = (NoteBlock)data;
            if (this.octave != null && this.octave.intValue() != noteBlock.getNote().getOctave()) {
                return false;
            }
            if (this.noteId != null && this.noteId.byteValue() != noteBlock.getNote().getId()) {
                return false;
            }
            if (this.tone != null && this.tone != noteBlock.getNote().getTone()) {
                return false;
            }
            if (this.sharped != null && this.sharped.booleanValue() != noteBlock.getNote().isSharped()) {
                return false;
            }
            if (this.instrument != null && this.instrument != noteBlock.getInstrument()) {
                return false;
            }
        }
        if (data instanceof Powerable) {
            Powerable powerable = (Powerable)data;
            if (this.powered != null && this.powered.booleanValue() != powerable.isPowered()) {
                return false;
            }
        }
        if (data instanceof MultipleFacing) {
            MultipleFacing multipleFacing = (MultipleFacing)data;
            if (!this.faces.isEmpty() && !this.faces.equals(multipleFacing.getFaces())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void load(Block block) {
        BlockData data = block.getBlockData();
        if (block.getState() instanceof Skull) {
            this.skull = XSkull.of(block).getDelegateProfile().getProfileValue();
        }
        if (data instanceof Directional) {
            Directional directional = (Directional)data;
            this.facing = directional.getFacing();
        }
        if (data instanceof Stairs) {
            Stairs stairs = (Stairs)data;
            this.stairShape = stairs.getShape();
        }
        if (data instanceof Orientable) {
            Orientable orientable = (Orientable)data;
            this.axis = orientable.getAxis();
        }
        if (data instanceof Rotatable) {
            Rotatable rotatable = (Rotatable)data;
            this.rotation = rotatable.getRotation();
        }
        if (data instanceof Ageable) {
            Ageable ageable = (Ageable)data;
            this.age = ageable.getAge();
        }
        if (data instanceof Waterlogged) {
            Waterlogged waterlogged = (Waterlogged)data;
            this.waterlogged = waterlogged.isWaterlogged();
        }
        if (data instanceof NoteBlock) {
            NoteBlock noteBlock = (NoteBlock)data;
            this.instrument = noteBlock.getInstrument();
            this.octave = noteBlock.getNote().getOctave();
            this.tone = noteBlock.getNote().getTone();
            this.sharped = noteBlock.getNote().isSharped();
            this.noteId = noteBlock.getNote().getId();
        }
        if (data instanceof Powerable) {
            Powerable powerable = (Powerable)data;
            this.powered = powerable.isPowered();
        }
        if (data instanceof MultipleFacing) {
            MultipleFacing multipleFacing = (MultipleFacing)data;
            this.faces.clear();
            this.faces.addAll(multipleFacing.getFaces());
        }
        log.fine(() -> String.format("Loaded block data %s (%s)", block.getType(), this));
    }

    @Override
    public void apply(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Directional && this.facing != null) {
            ((Directional)blockData).setFacing(this.facing);
        }
        if (blockData instanceof Stairs && this.stairShape != null) {
            ((Stairs)blockData).setShape(this.stairShape);
        }
        if (blockData instanceof Orientable && this.axis != null) {
            ((Orientable)blockData).setAxis(this.axis);
        }
        if (blockData instanceof Rotatable && this.rotation != null) {
            ((Rotatable)blockData).setRotation(this.rotation);
        }
        if (blockData instanceof Ageable && this.age != null) {
            Ageable ageable = (Ageable)blockData;
            if (this.age > ageable.getMaximumAge()) {
                ageable.setAge(ageable.getMaximumAge());
            } else {
                ageable.setAge(this.age.intValue());
            }
        }
        if (blockData instanceof Waterlogged && this.waterlogged != null) {
            Waterlogged waterlogged = (Waterlogged)blockData;
            waterlogged.setWaterlogged(this.waterlogged.booleanValue());
        }
        if (blockData instanceof NoteBlock) {
            Note note;
            NoteBlock noteBlock = (NoteBlock)blockData;
            if (this.instrument != null) {
                noteBlock.setInstrument(this.instrument);
            }
            if (this.noteId != null) {
                note = new Note((int)this.noteId.byteValue());
                noteBlock.setNote(note);
            }
            if (this.tone != null && this.octave != null) {
                note = new Note(this.octave.intValue(), this.tone, this.sharped != null && this.sharped != false);
                noteBlock.setNote(note);
            }
        }
        if (blockData instanceof Powerable) {
            Powerable powerable = (Powerable)blockData;
            if (this.powered != null) {
                powerable.setPowered(this.powered.booleanValue());
            }
        }
        if (blockData instanceof MultipleFacing) {
            MultipleFacing multipleFacing = (MultipleFacing)blockData;
            if (!this.faces.isEmpty()) {
                for (BlockFace face : multipleFacing.getAllowedFaces()) {
                    multipleFacing.setFace(face, this.faces.contains(face));
                }
            }
        }
        block.setBlockData(blockData);
        if (this.skull != null && block.getState() instanceof Skull) {
            XSkull.of(block).profile(Profileable.detect(this.skull)).apply();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.facing == null && this.stairShape == null && this.axis == null && this.rotation == null && this.age == null && this.instrument == null && this.octave == null && this.noteId == null && this.tone == null && this.sharped == null && this.powered == null && this.faces.isEmpty();
    }

    @Override
    public String getPrettyString() {
        HashMap<String, Object> entries = new HashMap<String, Object>();
        entries.put("facing", this.facing);
        entries.put("shape", this.stairShape);
        entries.put("axis", this.axis);
        entries.put("rotation", this.rotation);
        entries.put("age", this.age);
        entries.put("skull", this.skull);
        entries.put("noteId", this.noteId);
        entries.put("octave", this.octave);
        entries.put("tone", this.tone);
        entries.put("instrument", this.instrument);
        entries.put("sharped", this.sharped);
        String serialized = Serialization.serializeNodeDataEntries(entries);
        if (!this.faces.isEmpty()) {
            log.fine(serialized);
            String faces = this.faces.stream().map(face -> String.format("%s=true", face)).collect(Collectors.joining(","));
            serialized = serialized.substring(0, serialized.length() - 1) + faces + "]";
        }
        return serialized;
    }

    public String toString() {
        return "LatestNodeData{facing=" + this.facing + ", stairShape=" + this.stairShape + ", axis=" + this.axis + ", rotation=" + this.rotation + ", age=" + this.age + ", skull='" + this.skull + '\'' + ", powered=" + this.powered + ", instrument=" + this.instrument + ", noteId=" + this.noteId + ", octave=" + this.octave + ", tone=" + this.tone + ", sharped=" + this.sharped + ", faces=" + this.faces + '}';
    }

    @Generated
    public LatestNodeData() {
    }

    @Generated
    public void setFacing(BlockFace facing) {
        this.facing = facing;
    }

    @Generated
    public void setStairShape(Stairs.Shape stairShape) {
        this.stairShape = stairShape;
    }

    @Generated
    public void setAxis(Axis axis) {
        this.axis = axis;
    }

    @Generated
    public void setRotation(BlockFace rotation) {
        this.rotation = rotation;
    }

    @Generated
    public void setAge(Integer age) {
        this.age = age;
    }

    @Generated
    public void setSkull(String skull) {
        this.skull = skull;
    }

    @Generated
    public void setWaterlogged(Boolean waterlogged) {
        this.waterlogged = waterlogged;
    }

    @Generated
    public void setPowered(Boolean powered) {
        this.powered = powered;
    }

    @Generated
    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    @Generated
    public void setNoteId(Byte noteId) {
        this.noteId = noteId;
    }

    @Generated
    public void setOctave(Integer octave) {
        this.octave = octave;
    }

    @Generated
    public void setTone(Note.Tone tone) {
        this.tone = tone;
    }

    @Generated
    public void setSharped(Boolean sharped) {
        this.sharped = sharped;
    }
}

