/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.version.current;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import nl.aurorion.blockregen.region.RegionSelection;
import nl.aurorion.blockregen.version.api.WorldEditProvider;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestWorldEditProvider
implements WorldEditProvider {
    private final WorldEditPlugin worldEdit;

    public LatestWorldEditProvider(WorldEditPlugin worldEdit) {
        this.worldEdit = worldEdit;
    }

    public Region getSelection(@NotNull Player player) {
        Region selection;
        try {
            selection = this.worldEdit.getSession(player).getSelection(BukkitAdapter.adapt((org.bukkit.World)player.getWorld()));
        }
        catch (IncompleteRegionException e) {
            return null;
        }
        return selection;
    }

    @Override
    @Nullable
    public RegionSelection createSelection(@NotNull Player player) {
        Region selection = this.getSelection(player);
        if (selection == null || selection.getWorld() == null) {
            return null;
        }
        org.bukkit.World world = BukkitAdapter.adapt((World)selection.getWorld());
        Location min = BukkitAdapter.adapt((org.bukkit.World)world, (BlockVector3)selection.getMinimumPoint());
        Location max = BukkitAdapter.adapt((org.bukkit.World)world, (BlockVector3)selection.getMaximumPoint());
        return new RegionSelection(min, max);
    }
}

