/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.version.current;

import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.ProtectionQuery;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import nl.aurorion.blockregen.version.api.WorldGuardProvider;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LatestWorldGuardProvider
implements WorldGuardProvider {
    private final WorldGuardPlugin worldGuard;

    public LatestWorldGuardProvider(WorldGuardPlugin worldGuard) {
        this.worldGuard = worldGuard;
    }

    @Override
    public boolean canBreak(@NotNull Player player, @NotNull Location location) {
        ProtectionQuery protectionQuery = this.worldGuard.createProtectionQuery();
        return protectionQuery.testBlockBreak((Object)player, location.getBlock());
    }

    @Override
    public boolean canTrample(@NotNull Player player, @NotNull Location location) {
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        com.sk89q.worldedit.util.Location loc = new com.sk89q.worldedit.util.Location((Extent)localPlayer.getWorld(), location.getX(), location.getY(), location.getZ());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        return query.testState(loc, localPlayer, new StateFlag[]{Flags.TRAMPLE_BLOCKS});
    }
}

