/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.version.current;

import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.version.current.LatestNodeData;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.PinkPetals;

public class PinkNodeData
extends LatestNodeData {
    @Generated
    private static final Logger log = Logger.getLogger(PinkNodeData.class.getName());
    private Integer flowerAmount;

    @Override
    public boolean matches(Block block) {
        PinkPetals petals;
        boolean sup = super.matches(block);
        if (!sup) {
            return false;
        }
        BlockData data = block.getBlockData();
        return !(data instanceof PinkPetals) || this.flowerAmount == null || (petals = (PinkPetals)data).getFlowerAmount() == this.flowerAmount.intValue();
    }

    @Override
    public void load(Block block) {
        super.load(block);
        BlockData data = block.getBlockData();
        if (data instanceof PinkPetals) {
            PinkPetals petals = (PinkPetals)data;
            this.flowerAmount = petals.getFlowerAmount();
        }
    }

    @Override
    public void apply(Block block) {
        super.apply(block);
        BlockData data = block.getBlockData();
        if (data instanceof PinkPetals && this.flowerAmount != null) {
            PinkPetals petals = (PinkPetals)data;
            petals.setFlowerAmount(this.flowerAmount.intValue());
        }
        block.setBlockData(data);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.flowerAmount == null;
    }

    @Override
    public String toString() {
        return "PinkNodeData{.." + super.toString() + ", flowerAmount=" + this.flowerAmount + '}';
    }

    @Generated
    public PinkNodeData() {
    }

    @Generated
    public void setFlowerAmount(Integer flowerAmount) {
        this.flowerAmount = flowerAmount;
    }
}

