/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.compatibility;

import java.util.function.Supplier;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.compatibility.CompatibilityProvider;

public class ProviderContainer<T extends CompatibilityProvider> {
    private final BlockRegenPlugin plugin;
    private final String pluginName;
    private boolean found = false;
    private boolean requiresReloadAfterFound = false;
    private final Supplier<T> supplier;
    private T instance;

    public ProviderContainer(BlockRegenPlugin plugin, String pluginName, Supplier<T> provider) {
        this.plugin = plugin;
        this.pluginName = pluginName;
        this.supplier = provider;
    }

    public void load() throws IllegalStateException {
        this.instance = (CompatibilityProvider)this.supplier.get();
        ((CompatibilityProvider)this.instance).onLoad();
    }

    public T get() {
        if (this.instance == null) {
            this.load();
        }
        return this.instance;
    }

    public boolean isLoaded() {
        return this.instance != null;
    }

    public boolean requiresReloadAfterFound() {
        return this.requiresReloadAfterFound;
    }

    public ProviderContainer<T> requiresReloadAfterFound(boolean val) {
        this.requiresReloadAfterFound = val;
        return this;
    }

    public boolean isPluginEnabled() {
        return this.plugin.getServer().getPluginManager().isPluginEnabled(this.getPluginName());
    }

    @Generated
    public String getPluginName() {
        return this.pluginName;
    }

    @Generated
    public boolean isFound() {
        return this.found;
    }

    @Generated
    public void setFound(boolean found) {
        this.found = found;
    }

    @Generated
    public void setRequiresReloadAfterFound(boolean requiresReloadAfterFound) {
        this.requiresReloadAfterFound = requiresReloadAfterFound;
    }
}

