/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.compatibility.impl;

import dev.lone.itemsadder.api.CustomBlock;
import dev.lone.itemsadder.api.CustomStack;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.ParseException;
import nl.aurorion.blockregen.compatibility.CompatibilityProvider;
import nl.aurorion.blockregen.conditional.Condition;
import nl.aurorion.blockregen.drop.ItemProvider;
import nl.aurorion.blockregen.material.BlockRegenMaterial;
import nl.aurorion.blockregen.material.ItemsAdderMaterial;
import nl.aurorion.blockregen.material.parser.MaterialParser;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ItemsAdderProvider
extends CompatibilityProvider
implements MaterialParser,
ItemProvider {
    @Generated
    private static final Logger log = Logger.getLogger(ItemsAdderProvider.class.getName());

    public ItemsAdderProvider(BlockRegenPlugin plugin) {
        super(plugin, "ia");
        this.setFeatures("materials", "drops", "conditions");
    }

    @Override
    public void onLoad() {
        this.plugin.getPresetManager().getConditions().addProvider(this.getPrefix() + "/tool", (key, node) -> {
            String id = (String)node;
            if (CustomStack.getInstance((String)id) == null) {
                throw new ParseException("Invalid ItemsAdder item '" + id + "'.");
            }
            return Condition.of(ctx -> {
                ItemStack tool = (ItemStack)ctx.mustVar("tool");
                CustomStack toolBuilder = CustomStack.byItemStack((ItemStack)tool);
                return toolBuilder != null && toolBuilder.getNamespacedID().equalsIgnoreCase(id);
            });
        });
    }

    @Override
    @NotNull
    public BlockRegenMaterial parseMaterial(String input) {
        if (!CustomBlock.isInRegistry((String)input)) {
            throw new ParseException(String.format("'%s' is not a valid ItemsAdder custom block.", input));
        }
        return new ItemsAdderMaterial(input);
    }

    @Override
    public ItemStack createItem(String id, Function<String, String> parser, int amount) {
        CustomStack builder = CustomStack.getInstance((String)id);
        builder.setDisplayName(parser.apply(builder.getDisplayName()));
        ItemStack item = builder.getItemStack();
        item.setAmount(amount);
        ItemMeta meta = item.getItemMeta();
        if (meta.getLore() != null) {
            meta.setLore(meta.getLore().stream().map(parser).collect(Collectors.toList()));
        }
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public boolean exists(String id) {
        return CustomStack.isInRegistry((String)id);
    }

    @Override
    public boolean containsColon() {
        return true;
    }
}

