/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.compatibility.impl;

import com.nexomc.nexo.api.NexoBlocks;
import com.nexomc.nexo.api.NexoItems;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.ParseException;
import nl.aurorion.blockregen.compatibility.CompatibilityProvider;
import nl.aurorion.blockregen.conditional.Condition;
import nl.aurorion.blockregen.material.BlockRegenMaterial;
import nl.aurorion.blockregen.material.NexoMaterial;
import nl.aurorion.blockregen.material.parser.MaterialParser;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class NexoProvider
extends CompatibilityProvider
implements MaterialParser {
    public NexoProvider(BlockRegenPlugin plugin) {
        super(plugin, "nexo");
        this.setFeatures("materials", "conditions");
    }

    @Override
    public void onLoad() {
        this.plugin.getPresetManager().getConditions().addProvider(this.getPrefix() + "/tool", (key, node) -> {
            String id = (String)node;
            if (!NexoItems.exists((String)id)) {
                throw new ParseException("Invalid Nexo item '" + id + "'");
            }
            return Condition.of(ctx -> {
                ItemStack tool = (ItemStack)ctx.mustVar("tool");
                String toolId = NexoItems.idFromItem((ItemStack)tool);
                return id.equals(toolId);
            });
        });
    }

    @Override
    @NotNull
    public BlockRegenMaterial parseMaterial(String input) {
        if (!NexoBlocks.isCustomBlock((String)input)) {
            throw new ParseException(String.format("'%s' is not a Nexo block.", input));
        }
        return new NexoMaterial(this.plugin, input);
    }
}

