/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.configuration;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.ParseException;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadResult<T, E extends Exception> {
    @Generated
    private static final Logger log = Logger.getLogger(LoadResult.class.getName());
    private State state;
    private T value;
    private final E exception;
    private boolean throwByDefault = true;

    private LoadResult(T value, E e, State state) {
        this.value = value;
        this.state = state;
        this.exception = e;
    }

    public static <T> LoadResult<T, Exception> tryLoad(ConfigurationSection root, String path, Function<Object, T> runnable) {
        if (root == null || root.get(path) == null) {
            return LoadResult.empty();
        }
        try {
            return LoadResult.of(runnable.apply(root.get(path)));
        }
        catch (Exception e) {
            ParseException outer = new ParseException("Failed to load property '" + path + "' (value: '" + root.get(path) + "'): " + e.getMessage());
            return LoadResult.error(outer);
        }
    }

    @NotNull
    public static <T, O> LoadResult<T, Exception> tryLoad(ConfigurationSection root, String path, Class<O> clazz, Function<O, T> runnable) {
        if (root == null) {
            return LoadResult.empty();
        }
        Object o = root.get(path);
        if (o == null) {
            return LoadResult.empty();
        }
        if (!clazz.isAssignableFrom(o.getClass())) {
            return LoadResult.error(new ParseException("Invalid type '" + o.getClass().getSimpleName() + "'. Expected '" + clazz.getSimpleName() + "'"));
        }
        Object v = o;
        try {
            return LoadResult.of(runnable.apply(v));
        }
        catch (Exception e) {
            log.warning("Failed to load property '" + path + "' (value: '" + root.get(path) + "'): " + e.getMessage());
            return LoadResult.error(e);
        }
    }

    @NotNull
    public static <T, E extends Exception> LoadResult<T, E> empty() {
        return new LoadResult<Object, Object>(null, null, State.EMPTY);
    }

    @NotNull
    public static <T, E extends Exception> LoadResult<T, E> of(@Nullable T value) {
        return new LoadResult<T, Object>(value, null, State.FULL);
    }

    @NotNull
    public static <T, E extends Exception> LoadResult<T, E> error(@NotNull E e) {
        return new LoadResult<Object, E>(null, e, State.ERROR);
    }

    public boolean isEmpty() {
        return this.state == State.EMPTY;
    }

    public boolean isPresent() {
        return this.state == State.FULL;
    }

    public boolean isError() {
        return this.state == State.ERROR;
    }

    @NotNull
    public LoadResult<T, E> setIfState(@NotNull State state, T def) {
        if (this.state == state) {
            this.state = State.FULL;
            this.value = def;
        }
        return this;
    }

    @NotNull
    public LoadResult<T, E> ifError(T def) {
        return this.setIfState(State.ERROR, def);
    }

    @NotNull
    public LoadResult<T, E> ifEmpty(T def) {
        return this.setIfState(State.EMPTY, def);
    }

    @NotNull
    public LoadResult<T, E> ifNotFull(T def) {
        if (this.state != State.FULL) {
            this.state = State.FULL;
            this.value = def;
        }
        return this;
    }

    public T getIfState(@NotNull State state, T def) {
        return state == this.state ? def : this.value;
    }

    public T orElseIfError(T def) {
        return this.getIfState(State.ERROR, def);
    }

    public T orElseIfEmpty(T def) {
        return this.getIfState(State.EMPTY, def);
    }

    public LoadResult<T, E> throwIfError() {
        if (this.state == State.ERROR) {
            throw this.exception;
        }
        return this;
    }

    @NotNull
    public LoadResult<T, E> setThrowByDefault(boolean val) {
        this.throwByDefault = val;
        return this;
    }

    public void apply(Consumer<T> consumer) {
        if (this.throwByDefault) {
            this.throwIfError();
        }
        if (this.state == State.FULL) {
            consumer.accept(this.value);
        }
    }

    public T get() {
        if (this.throwByDefault) {
            this.throwIfError();
        }
        return this.value;
    }

    public E error() {
        return this.exception;
    }

    @Generated
    public boolean isThrowByDefault() {
        return this.throwByDefault;
    }

    public static enum State {
        EMPTY,
        FULL,
        ERROR;

    }
}

