/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.listener;

import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPluginImpl;
import nl.aurorion.blockregen.Message;
import nl.aurorion.blockregen.preset.BlockPreset;
import nl.aurorion.blockregen.regeneration.struct.RegenerationProcess;
import nl.aurorion.blockregen.region.RegionSelection;
import nl.aurorion.blockregen.region.struct.RegenerationArea;
import nl.aurorion.blockregen.version.api.NodeData;
import nl.aurorion.blockregen.xseries.XMaterial;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class PlayerListener
implements Listener {
    @Generated
    private static final Logger log = Logger.getLogger(PlayerListener.class.getName());
    private final BlockRegenPluginImpl plugin;

    public PlayerListener(BlockRegenPluginImpl instance) {
        this.plugin = instance;
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        XMaterial toolMaterial;
        Player player = event.getPlayer();
        if (this.plugin.getVersionManager().isCurrentAbove("1.9", true) && event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getClickedBlock() == null) {
            return;
        }
        if (this.plugin.getRegenerationManager().hasDataCheck(player)) {
            XMaterial material;
            event.setCancelled(true);
            try {
                material = this.plugin.getVersionManager().getMethods().getType(event.getClickedBlock());
            }
            catch (IllegalArgumentException e) {
                log.fine("Unknown block material " + event.getClickedBlock().getType() + " in data check.");
                Message.UNKNOWN_MATERIAL.send(player);
                return;
            }
            NodeData data = this.plugin.getVersionManager().createNodeData();
            data.load(event.getClickedBlock());
            Message.DATA_CHECK.mapAndSend(player, str -> str.replace("%block%", material.name()));
            if (!data.isEmpty()) {
                Message.DATA_CHECK_NODE_DATA.mapAndSend(player, str -> str.replace("%data%", String.format("%s%s", material.name(), data.getPrettyString())));
            }
            return;
        }
        ItemStack tool = this.plugin.getVersionManager().getMethods().getItemInMainHand(player);
        try {
            toolMaterial = XMaterial.matchXMaterial(tool);
        }
        catch (IllegalArgumentException e) {
            log.fine(() -> String.format("Unknown tool material %s.", tool.getType()));
            if (!BlockRegenPluginImpl.getInstance().getConfig().getBoolean("Ignore-Unknown-Materials", false)) {
                throw e;
            }
            return;
        }
        if (player.hasPermission("blockregen.select") && this.plugin.getVersionManager().getWorldEditProvider() == null && toolMaterial == XMaterial.WOODEN_AXE) {
            RegionSelection selection = this.plugin.getRegionManager().getOrCreateSelection(player);
            if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                selection.setFirst(event.getClickedBlock().getLocation());
                Message.SELECT_FIRST.mapAndSend(player, str -> str.replace("%x%", String.format("%.0f", selection.getFirst().getX())).replace("%y%", String.format("%.0f", selection.getFirst().getY())).replace("%z%", String.format("%.0f", selection.getFirst().getZ())));
            } else {
                selection.setSecond(event.getClickedBlock().getLocation());
                Message.SELECT_SECOND.mapAndSend(player, str -> str.replace("%x%", String.format("%.0f", selection.getSecond().getX())).replace("%y%", String.format("%.0f", selection.getSecond().getY())).replace("%z%", String.format("%.0f", selection.getSecond().getZ())));
            }
            event.setCancelled(true);
            return;
        }
        RegenerationArea region = this.plugin.getRegionManager().getArea(event.getClickedBlock());
        if (player.hasPermission("blockregen.region") && toolMaterial == XMaterial.WOODEN_SHOVEL && region != null) {
            event.setCancelled(true);
            BlockPreset preset = this.plugin.getPresetManager().getPreset(event.getClickedBlock());
            if (preset == null) {
                RegenerationProcess process = this.plugin.getRegenerationManager().getProcess(event.getClickedBlock());
                if (process == null) {
                    return;
                }
                preset = process.getPreset();
            }
            String presetName = preset.getName();
            if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                if (region.hasPreset(preset.getName())) {
                    Message.HAS_PRESET_ALREADY.mapAndSend(player, str -> str.replace("%region%", region.getName()).replace("%preset%", presetName));
                    return;
                }
                region.addPreset(presetName);
                Message.PRESET_ADDED.mapAndSend(player, str -> str.replace("%region%", region.getName()).replace("%preset%", presetName));
            } else {
                if (!region.hasPreset(presetName)) {
                    Message.DOES_NOT_HAVE_PRESET.mapAndSend(player, str -> str.replace("%region%", region.getName()).replace("%preset%", presetName));
                    return;
                }
                region.removePreset(presetName);
                Message.PRESET_REMOVED.mapAndSend(player, str -> str.replace("%region%", region.getName()).replace("%preset%", presetName));
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("blockregen.admin") && this.plugin.newVersion != null) {
            Message.UPDATE.mapAndSend(player, str -> str.replaceAll("(?i)%newVersion%", this.plugin.newVersion).replaceAll("(?i)%version%", this.plugin.getDescription().getVersion()));
        }
        this.plugin.getEventManager().addBars(player);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.plugin.getEventManager().removeBars(event.getPlayer());
    }
}

