/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.material;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.Pair;
import nl.aurorion.blockregen.ParseException;
import nl.aurorion.blockregen.material.BlockRegenMaterial;
import nl.aurorion.blockregen.material.MinecraftMaterial;
import nl.aurorion.blockregen.material.parser.MaterialParser;
import nl.aurorion.blockregen.preset.material.PlacementMaterial;
import nl.aurorion.blockregen.preset.material.TargetMaterial;
import nl.aurorion.blockregen.xseries.XMaterial;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaterialManager {
    @Generated
    private static final Logger log = Logger.getLogger(MaterialManager.class.getName());
    private static final Pattern COLON_PATTERN = Pattern.compile("(?<!http(?s)):(?!//)");
    private static final Pattern PREFIX_PATTERN = Pattern.compile("^(\\w+):(.*)");
    private final Map<String, MaterialParser> registeredParsers = new HashMap<String, MaterialParser>();
    private final BlockRegenPlugin plugin;

    public MaterialManager(BlockRegenPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerParser(@Nullable String prefix, @NotNull MaterialParser parser) {
        MaterialParser registeredParser = this.registeredParsers.get(prefix = prefix == null ? null : prefix.toLowerCase());
        if (registeredParser != null && registeredParser.getClass() == parser.getClass()) {
            return;
        }
        this.registeredParsers.put(prefix, parser);
        log.fine(String.format("Registered material parser with prefix %s", prefix));
    }

    @Nullable
    public MaterialParser getParser(@Nullable String prefix) {
        return this.registeredParsers.get(prefix == null ? null : prefix.toLowerCase());
    }

    @NotNull
    private Pair<BlockRegenMaterial, Double> parseMaterialAndChance(@NotNull MaterialParser parser, @NotNull String input) {
        Matcher matcher = COLON_PATTERN.matcher(input);
        log.fine(() -> "Input for parseMaterialAndChance: '" + input + "'");
        ArrayList<MatchResult> results = new ArrayList<MatchResult>();
        while (matcher.find()) {
            results.add(matcher.toMatchResult());
        }
        long count = results.size();
        log.fine(() -> String.join((CharSequence)",", results.stream().map(MatchResult::group).collect(Collectors.joining(","))) + " " + count);
        if (count != 0L) {
            BlockRegenMaterial material;
            int lastColon = ((MatchResult)results.get(results.size() - 1)).end();
            boolean withChance = true;
            String rawMaterialInput = input.substring(0, lastColon - 1);
            if (parser.containsColon() && count == 1L) {
                rawMaterialInput = input;
                withChance = false;
            }
            try {
                material = parser.parseMaterial(rawMaterialInput);
            }
            catch (Exception e) {
                throw new ParseException(String.format("Failed to parse material '%s' with parser '%s'", rawMaterialInput, parser.getClass().getSimpleName()), e, true);
            }
            if (withChance) {
                String rawChanceInput = input.substring(lastColon);
                log.fine(() -> "Raw chance input: '" + rawChanceInput + "'");
                try {
                    double chance = Double.parseDouble(rawChanceInput);
                    return new Pair<BlockRegenMaterial, Double>(material, chance / 100.0);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Invalid chance '" + rawChanceInput + "', has to be a number.");
                }
            }
            return new Pair<BlockRegenMaterial, Object>(material, null);
        }
        log.fine(() -> "Single material input for parseMaterialAndChance: '" + input + "'");
        try {
            BlockRegenMaterial material = parser.parseMaterial(input);
            return new Pair<BlockRegenMaterial, Object>(material, null);
        }
        catch (Exception e) {
            throw new ParseException(String.format("Failed to parse material '%s' with parser '%s'", input, parser.getClass().getSimpleName()), e, true);
        }
    }

    @NotNull
    public TargetMaterial parseTargetMaterial(String input) {
        List<String> materials = Arrays.asList(input.split(";"));
        if (materials.isEmpty()) {
            throw new ParseException("Target material " + input + " doesn't have the correct syntax.");
        }
        ArrayList<BlockRegenMaterial> targetMaterials = new ArrayList<BlockRegenMaterial>();
        for (String materialInput : materials) {
            BlockRegenMaterial material = this.parseMaterial(materialInput);
            targetMaterials.add(material);
        }
        return TargetMaterial.of(targetMaterials);
    }

    @NotNull
    public PlacementMaterial parsePlacementMaterial(@NotNull String input) {
        List<String> materials = Arrays.asList(input.split(";"));
        ArrayList<BlockRegenMaterial> restMaterials = new ArrayList<BlockRegenMaterial>();
        HashMap<BlockRegenMaterial, Double> valuedMaterials = new HashMap<BlockRegenMaterial, Double>();
        if (materials.isEmpty()) {
            throw new ParseException("Placement material " + input + " doesn't have the correct syntax.");
        }
        for (String materialInput : materials) {
            int firstColon = materialInput.indexOf(":");
            String prefix = firstColon == -1 ? null : materialInput.substring(0, firstColon);
            MaterialParser parser = this.getParser(prefix);
            if (parser == null) {
                parser = this.getParser(null);
                if (parser == null) {
                    throw new ParseException(String.format("Material '%s' is invalid. No valid material parser found.", input));
                }
                log.fine(() -> "No prefix");
                Pair<BlockRegenMaterial, Double> result = this.parseMaterialAndChance(parser, materialInput);
                if (result.getSecond() == null) {
                    restMaterials.add(result.getFirst());
                    continue;
                }
                valuedMaterials.put(result.getFirst(), result.getSecond());
                continue;
            }
            String rest = materialInput.substring(firstColon + 1);
            log.fine(() -> "Prefix: '" + prefix + "'");
            log.fine(() -> "Rest: '" + rest + "'");
            Pair<BlockRegenMaterial, Double> result = this.parseMaterialAndChance(parser, rest);
            if (result.getSecond() == null) {
                restMaterials.add(result.getFirst());
                continue;
            }
            valuedMaterials.put(result.getFirst(), result.getSecond());
            log.fine(() -> String.format("Added material %s at chance %.2f%%", result.getFirst(), result.getSecond()));
        }
        double rest = 1.0 - valuedMaterials.values().stream().mapToDouble(e -> e).sum();
        if (rest > 0.0) {
            if (restMaterials.isEmpty()) {
                valuedMaterials.put(new MinecraftMaterial(this.plugin, XMaterial.AIR, null), rest);
                log.fine(() -> "Only a single material with chance provided. Filling the rest with AIR.");
            } else if (restMaterials.size() == 1) {
                valuedMaterials.put((BlockRegenMaterial)restMaterials.get(0), rest);
                log.fine(() -> String.format("Added material %s at chance %.2f%%", restMaterials.get(0), rest));
            } else {
                double chance = rest / (double)restMaterials.size();
                restMaterials.forEach(mat -> valuedMaterials.put((BlockRegenMaterial)mat, chance));
            }
        }
        try {
            return PlacementMaterial.from(valuedMaterials);
        }
        catch (IllegalArgumentException e2) {
            throw new ParseException(e2);
        }
    }

    @NotNull
    public BlockRegenMaterial parseMaterial(@NotNull String input) {
        MaterialParser parser;
        if (Strings.isNullOrEmpty((String)input)) {
            throw new ParseException("Empty input.");
        }
        Matcher matcher = PREFIX_PATTERN.matcher(input);
        String prefix = null;
        String sanitized = input;
        if (matcher.matches()) {
            prefix = matcher.group(1);
            sanitized = matcher.group(2);
        }
        if ((parser = this.getParser(prefix)) == null) {
            throw new ParseException(String.format("No valid parser found for prefix '%s'", prefix));
        }
        return parser.parseMaterial(sanitized);
    }
}

