/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.material;

import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.material.BlockRegenMaterial;
import nl.aurorion.blockregen.util.Blocks;
import nl.aurorion.blockregen.version.api.NodeData;
import nl.aurorion.blockregen.xseries.XMaterial;
import org.bukkit.block.Block;
import org.jetbrains.annotations.Nullable;

public class MinecraftMaterial
implements BlockRegenMaterial {
    private final BlockRegenPlugin plugin;
    private final XMaterial material;
    @Nullable
    private final NodeData nodeData;

    public MinecraftMaterial(BlockRegenPlugin plugin, XMaterial material, @Nullable NodeData nodeData) {
        this.plugin = plugin;
        this.material = material;
        this.nodeData = nodeData;
    }

    public MinecraftMaterial(BlockRegenPlugin plugin, XMaterial material) {
        this.plugin = plugin;
        this.material = material;
        this.nodeData = null;
    }

    @Override
    public boolean check(Block block) {
        XMaterial xMaterial = this.plugin.getBlockType(block);
        return xMaterial == this.material && (this.nodeData == null || this.nodeData.matches(block));
    }

    @Override
    public void applyData(Block block) {
        if (this.nodeData != null) {
            this.nodeData.apply(block);
        }
    }

    @Override
    public void setType(Block block) {
        this.plugin.getVersionManager().getMethods().setType(block, this.material);
    }

    @Override
    public boolean requiresSolidGround() {
        return Blocks.isMultiblockCrop(this.material) || Blocks.requiresFarmland(this.material) || Blocks.reliesOnBlockBelow(this.material);
    }

    @Override
    public boolean requiresFarmland() {
        return Blocks.requiresFarmland(this.material);
    }

    @Override
    public boolean applyOriginalData() {
        return true;
    }

    public String toString() {
        return "MinecraftMaterial{material=" + this.material + ", data=" + this.nodeData + '}';
    }

    @Generated
    public XMaterial getMaterial() {
        return this.material;
    }

    @Nullable
    @Generated
    public NodeData getNodeData() {
        return this.nodeData;
    }
}

