/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.preset;

import com.google.common.base.Strings;
import lombok.Generated;
import nl.aurorion.blockregen.ParseException;
import nl.aurorion.blockregen.preset.NumberValue;
import nl.aurorion.blockregen.util.Parsing;
import org.jetbrains.annotations.NotNull;

public class FixedNumberValue
implements NumberValue {
    private final double value;

    FixedNumberValue(double value) {
        this.value = value;
    }

    @NotNull
    public static FixedNumberValue from(@NotNull Object o) {
        if (o instanceof Number) {
            return FixedNumberValue.of((Number)o);
        }
        if (o instanceof String) {
            return FixedNumberValue.parse((String)o);
        }
        throw new ParseException("Invalid type '" + o.getClass().getSimpleName() + "' for number value.");
    }

    @NotNull
    public static FixedNumberValue of(@NotNull Number n) {
        return new FixedNumberValue(n.doubleValue());
    }

    @NotNull
    public static FixedNumberValue parse(String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            throw new ParseException("No input for FixedNumberValue.");
        }
        double value = Parsing.parseDouble(input, "Invalid value supplied: '" + input + "'.");
        return new FixedNumberValue(value);
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int getInt() {
        return (int)Math.round(this.value);
    }

    public String toString() {
        return "FixedNumberValue{value=" + this.value + '}';
    }

    @Generated
    public double getValue() {
        return this.value;
    }
}

