/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.preset;

import com.google.common.base.Strings;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.BlockRegenPluginImpl;
import nl.aurorion.blockregen.ParseException;
import nl.aurorion.blockregen.conditional.Condition;
import nl.aurorion.blockregen.configuration.LoadResult;
import nl.aurorion.blockregen.drop.ItemProvider;
import nl.aurorion.blockregen.event.struct.EventBossBar;
import nl.aurorion.blockregen.event.struct.PresetEvent;
import nl.aurorion.blockregen.preset.BlockPreset;
import nl.aurorion.blockregen.preset.NumberValue;
import nl.aurorion.blockregen.preset.PresetConditions;
import nl.aurorion.blockregen.preset.PresetRewards;
import nl.aurorion.blockregen.preset.condition.ConditionRelation;
import nl.aurorion.blockregen.preset.condition.Conditions;
import nl.aurorion.blockregen.preset.condition.GenericConditionProvider;
import nl.aurorion.blockregen.preset.drop.DropItem;
import nl.aurorion.blockregen.preset.drop.Enchant;
import nl.aurorion.blockregen.preset.drop.ExperienceDrop;
import nl.aurorion.blockregen.preset.drop.ExternalDropItem;
import nl.aurorion.blockregen.preset.drop.MinecraftDropItem;
import nl.aurorion.blockregen.preset.material.TargetMaterial;
import nl.aurorion.blockregen.region.struct.RegenerationArea;
import nl.aurorion.blockregen.util.Parsing;
import nl.aurorion.blockregen.xseries.XMaterial;
import nl.aurorion.blockregen.xseries.XSound;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PresetManager {
    @Generated
    private static final Logger log = Logger.getLogger(PresetManager.class.getName());
    private final BlockRegenPlugin plugin;
    private final Map<String, BlockPreset> presets = new HashMap<String, BlockPreset>();
    private final GenericConditionProvider conditions = GenericConditionProvider.empty();
    private boolean retry = false;

    public PresetManager(BlockRegenPlugin plugin) {
        this.plugin = plugin;
    }

    public BlockPreset getPreset(@Nullable String name) {
        return this.presets.get(name);
    }

    @Nullable
    public BlockPreset getPreset(@NotNull Block block) {
        for (BlockPreset preset : this.presets.values()) {
            if (!preset.getTargetMaterial().matches(block)) continue;
            return preset;
        }
        return null;
    }

    @Nullable
    public BlockPreset getPreset(@NotNull Block block, @Nullable RegenerationArea region) {
        if (region == null) {
            return this.getPreset(block);
        }
        for (BlockPreset preset : this.presets.values()) {
            if (!preset.getTargetMaterial().matches(block) || !region.hasPreset(preset.getName())) continue;
            return preset;
        }
        return null;
    }

    public Map<String, BlockPreset> getPresets() {
        return Collections.unmodifiableMap(this.presets);
    }

    public void loadSection(ConfigurationSection section) {
        for (String key : section.getKeys(false)) {
            log.fine(key);
            if (Objects.equals(key, "Blocks")) continue;
            try {
                ConfigurationSection blockSection = section.getConfigurationSection(key);
                if (blockSection == null) {
                    log.warning(String.format("Key '%s' is not a valid block section.", key));
                    continue;
                }
                this.load(blockSection);
            }
            catch (Exception e) {
                ParseException parseException;
                log.log(Level.WARNING, String.format("Could not load preset '%s': %s", key, e.getMessage()), e);
                if (BlockRegenPlugin.getInstance().getLogLevel().intValue() < Level.FINE.intValue()) {
                    e.printStackTrace();
                }
                if (!(e instanceof ParseException) || !(parseException = (ParseException)e).isShouldRetry()) continue;
                this.retry = true;
            }
        }
    }

    public void load() {
        this.retry = false;
        this.presets.clear();
        this.plugin.getEventManager().clearEvents();
        FileConfiguration blocklist = this.plugin.getFiles().getBlockList().getFileConfiguration();
        ConfigurationSection blocksSection = blocklist.getConfigurationSection("Blocks");
        if (blocksSection != null) {
            this.loadSection(blocksSection);
        }
        this.loadSection((ConfigurationSection)blocklist);
        if (this.retry) {
            log.info("Some presets were not loaded. Retrying after the server loads...");
        }
        log.info("Loaded " + this.presets.size() + " block preset(s)...");
        log.info("Added " + this.plugin.getEventManager().getLoadedEvents().size() + " event(s)...");
    }

    public void reattemptLoad() {
        if (!this.retry) {
            return;
        }
        this.retry = false;
        log.info("Reloading presets...");
        this.load();
    }

    public void load(@NotNull ConfigurationSection section) {
        String jobsRequired;
        String enchantsRequired;
        String regenParticle;
        String particleName;
        Objects.requireNonNull(section);
        String name = section.getName();
        BlockPreset preset = new BlockPreset(name);
        String targetMaterialInput = section.getString("target-material", name);
        TargetMaterial targetMaterial = this.plugin.getMaterialManager().parseTargetMaterial(targetMaterialInput);
        preset.setTargetMaterial(targetMaterial);
        log.fine(() -> String.format("target-material: %s", preset.getTargetMaterial()));
        String replaceMaterial = section.getString("replace-block");
        if (!Strings.isNullOrEmpty((String)replaceMaterial)) {
            try {
                preset.setReplaceMaterial(this.plugin.getMaterialManager().parsePlacementMaterial(replaceMaterial));
            }
            catch (ParseException e) {
                log.warning("Dynamic material ( " + replaceMaterial + " ) in 'replace-block' for " + name + " is invalid: " + e.getMessage());
            }
        }
        log.fine(() -> String.format("replace-material: %s", preset.getReplaceMaterial()));
        String regenerateIntoInput = section.getString("regenerate-into");
        if (!Strings.isNullOrEmpty((String)regenerateIntoInput)) {
            try {
                preset.setRegenMaterial(this.plugin.getMaterialManager().parsePlacementMaterial(regenerateIntoInput));
            }
            catch (ParseException e) {
                log.warning("Dynamic material ( " + replaceMaterial + " ) in 'regenerate-into' for " + name + " is invalid: " + e.getMessage());
            }
        }
        log.fine(() -> String.format("regenerate-into: %s", preset.getRegenMaterial()));
        LoadResult.tryLoad(section, "regen-delay", NumberValue.Parser::load).ifEmpty(NumberValue.fixed(3.0)).throwIfError().apply(preset::setDelay);
        preset.setNaturalBreak(section.getBoolean("natural-break", true));
        preset.setDisablePhysics(section.getBoolean("disable-physics", false));
        if (preset.isDisablePhysics() && this.plugin.getVersionManager().isCurrentBelow("1.13.2", false)) {
            log.warning("Option `disable-physics` has not effect on versions below 1.13.2");
        }
        preset.setApplyFortune(section.getBoolean("apply-fortune", true));
        preset.setDropNaturally(section.getBoolean("drop-naturally", true));
        preset.setApplyMending(section.getBoolean("apply-mending", true));
        preset.setHandleCrops(section.getBoolean("handle-crops", true));
        preset.setCheckSolidGround(section.getBoolean("check-solid-ground", true));
        preset.setRegenerateWhole(section.getBoolean("regenerate-whole", false));
        String sound = section.getString("sound");
        if (!Strings.isNullOrEmpty((String)sound)) {
            Optional<XSound> xSound = XSound.of(sound);
            if (!xSound.isPresent()) {
                log.warning("Sound '" + sound + "' in preset " + name + " is invalid.");
            } else {
                preset.setSound(xSound.get());
            }
        }
        if (!Strings.isNullOrEmpty((String)(particleName = section.getString("particles")))) {
            preset.setParticle(particleName);
        }
        if (!Strings.isNullOrEmpty((String)(regenParticle = section.getString("regeneration-particles")))) {
            preset.setRegenerationParticle(regenParticle);
        }
        PresetConditions conditions = new PresetConditions();
        String toolsRequired = section.getString("tool-required");
        if (!Strings.isNullOrEmpty((String)toolsRequired)) {
            conditions.setToolsRequired(toolsRequired);
        }
        if (!Strings.isNullOrEmpty((String)(enchantsRequired = section.getString("enchant-required")))) {
            conditions.setEnchantsRequired(enchantsRequired);
        }
        if (this.plugin.getCompatibilityManager().getJobs().isLoaded() && !Strings.isNullOrEmpty((String)(jobsRequired = section.getString("jobs-check")))) {
            conditions.setJobsRequired(jobsRequired);
        }
        preset.setConditions(conditions);
        try {
            preset.setCondition(this.loadConditions(section, "conditions"));
        }
        catch (ParseException e) {
            throw new ParseException("Failed to load conditions for preset '" + preset.getName() + "': " + e.getMessage());
        }
        PresetRewards rewards = this.loadRewards(section, preset);
        preset.setRewards(rewards);
        try {
            PresetEvent event = this.loadEvent(section.getConfigurationSection("event"), preset);
            if (event != null) {
                this.plugin.getEventManager().addEvent(event);
            }
        }
        catch (ParseException e) {
            log.warning("Failed to load event for preset '" + preset.getName() + "': " + e.getMessage());
        }
        this.presets.put(name, preset);
        log.fine(() -> "Loaded preset " + preset);
    }

    @NotNull
    private Condition loadConditions(@NotNull ConfigurationSection root, @NotNull String key) {
        Object node = root.get(key);
        if (node == null) {
            return Condition.truthy();
        }
        return Conditions.fromNodeMultiple(node, ConditionRelation.AND, this.conditions);
    }

    private PresetEvent loadEvent(ConfigurationSection section, BlockPreset preset) {
        if (section == null) {
            return null;
        }
        PresetEvent event = new PresetEvent(preset.getName());
        String displayName = section.getString("event-name");
        if (displayName == null) {
            throw new ParseException("Event name is missing.");
        }
        event.setDisplayName(displayName);
        event.setDoubleDrops(section.getBoolean("double-drops", false));
        event.setDoubleExperience(section.getBoolean("double-exp", false));
        if (BlockRegenPluginImpl.getInstance().getVersionManager().isCurrentAbove("1.8", false)) {
            event.setBossBar(EventBossBar.load(section.getConfigurationSection("bossbar"), "&eEvent &6" + displayName + " &eis active!"));
        }
        event.setItem(this.loadDrop(section.getConfigurationSection("custom-item"), preset));
        LoadResult.tryLoad(section, "custom-item.rarity", NumberValue.Parser::load).ifNotFull(NumberValue.fixed(1.0)).apply(event::setItemRarity);
        event.setRewards(this.loadRewards(section, preset));
        return event;
    }

    /*
     * Unable to fully structure code
     */
    private PresetRewards loadRewards(ConfigurationSection section, BlockPreset preset) {
        if (section == null) {
            return new PresetRewards();
        }
        rewards = new PresetRewards();
        rewards.parseConsoleCommands(PresetManager.getStringOrList(section, new String[]{"console-commands", "console-command", "commands", "command"}));
        rewards.parsePlayerCommands(PresetManager.getStringOrList(section, new String[]{"player-commands", "player-command"}));
        LoadResult.tryLoad(section, "money", (Function<Object, NumberValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, load(java.lang.Object ), (Ljava/lang/Object;)Lnl/aurorion/blockregen/preset/NumberValue;)()).ifNotFull(NumberValue.fixed(0.0)).apply((Consumer<NumberValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, setMoney(nl.aurorion.blockregen.preset.NumberValue ), (Lnl/aurorion/blockregen/preset/NumberValue;)V)((PresetRewards)rewards));
        dropSection = section.getConfigurationSection("drop-item");
        if (dropSection != null) {
            if (dropSection.contains("material") || dropSection.contains("item")) {
                try {
                    drop = this.loadDrop(dropSection, preset);
                    if (drop == null) ** GOTO lbl27
                    rewards.getDrops().add(drop);
                }
                catch (ParseException e) {
                    throw new ParseException("Failed to load drop item '" + dropSection.getName() + "': " + e.getMessage());
                }
            } else {
                for (String dropName : dropSection.getKeys(false)) {
                    drop = this.loadDrop(dropSection.getConfigurationSection(dropName), preset);
                    if (drop == null) continue;
                    rewards.getDrops().add(drop);
                }
            }
lbl27:
            // 3 sources

            PresetManager.log.fine((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$loadRewards$4(nl.aurorion.blockregen.preset.PresetRewards ), ()Ljava/lang/String;)((PresetRewards)rewards));
        }
        return rewards;
    }

    @Nullable
    private DropItem loadDrop(ConfigurationSection section, BlockPreset preset) {
        if (section == null) {
            return null;
        }
        if (section.contains("item")) {
            String item = section.getString("item");
            if (item == null) {
                return null;
            }
            String[] parts = new String[]{item};
            int index = item.indexOf(58);
            if (index != -1) {
                parts = new String[]{item.substring(0, index), item.substring(index + 1)};
            }
            String prefix = parts[0];
            String id = parts[1];
            ItemProvider provider = this.plugin.getItemManager().getProvider(prefix.toLowerCase());
            if (provider == null) {
                throw new ParseException("Invalid prefix '" + prefix + "'");
            }
            if (!provider.exists(parts[1])) {
                throw new ParseException("External item '" + id + "' doesn't exist with the providing plugin.");
            }
            ExternalDropItem drop = new ExternalDropItem(provider, id);
            drop.setDropNaturally(section.getBoolean("drop-naturally", preset.isDropNaturally()));
            drop.setApplyFortune(section.getBoolean("apply-fortune", preset.isApplyFortune()));
            LoadResult.tryLoad(section, "chance", NumberValue.Parser::load).ifNotFull(NumberValue.fixed(100.0)).apply(drop::setChance);
            LoadResult.tryLoad(section, "amount", NumberValue.Parser::load).ifNotFull(NumberValue.fixed(1.0)).apply(drop::setAmount);
            LoadResult.tryLoad(section, "conditions", node -> Conditions.fromNodeMultiple(node, ConditionRelation.AND, this.conditions)).ifNotFull(Condition.truthy()).apply(drop::setCondition);
            return drop;
        }
        XMaterial material = Parsing.parseMaterial(section.getString("material"));
        MinecraftDropItem drop = new MinecraftDropItem(material);
        LoadResult.tryLoad(section, "amount", NumberValue.Parser::load).ifNotFull(NumberValue.fixed(1.0)).apply(drop::setAmount);
        drop.setDisplayName(section.getString("name"));
        drop.setLore(section.getStringList("lores"));
        drop.setEnchants(Enchant.loadSet(section.getStringList("enchants")));
        drop.setItemFlags(section.getStringList("flags").stream().map(str -> Parsing.parseEnum(str, ItemFlag.class, e -> log.warning("Could not parse ItemFlag from " + str))).collect(Collectors.toSet()));
        drop.setDropNaturally(section.getBoolean("drop-naturally", preset.isDropNaturally()));
        drop.setApplyFortune(section.getBoolean("apply-fortune", preset.isApplyFortune()));
        drop.setExperienceDrop(ExperienceDrop.load(section.getConfigurationSection("exp"), drop));
        LoadResult.tryLoad(section, "chance", NumberValue.Parser::load).ifNotFull(NumberValue.fixed(100.0)).apply(drop::setChance);
        LoadResult.tryLoad(section, "custom-model-data", val -> {
            if (val instanceof String) {
                return Parsing.parseInt((String)val);
            }
            if (val instanceof Number) {
                return (Integer)val;
            }
            throw new ParseException(String.format("Invalid type ('%s') of value '%s'", val.getClass().getSimpleName(), val));
        }).apply(drop::setCustomModelData);
        LoadResult.tryLoad(section, "conditions", node -> Conditions.fromNodeMultiple(node, ConditionRelation.AND, this.conditions)).ifNotFull(Condition.truthy()).apply(drop::setCondition);
        if (section.isSet("item-model")) {
            String key = section.getString("item-model");
            drop.setItemModel(NamespacedKey.fromString((String)Objects.requireNonNull(key)));
        }
        return drop;
    }

    @NotNull
    private static List<String> getStringOrList(ConfigurationSection section, String ... keys) {
        for (String key : keys) {
            if (section.get(key) == null) continue;
            if (section.isList(key)) {
                return section.getStringList(key);
            }
            if (!section.isString(key)) continue;
            String str = section.getString(key);
            return Collections.singletonList(str);
        }
        return new ArrayList<String>();
    }

    @Generated
    public GenericConditionProvider getConditions() {
        return this.conditions;
    }

    @Generated
    public boolean isRetry() {
        return this.retry;
    }

    private static /* synthetic */ String lambda$loadRewards$4(PresetRewards rewards) {
        return "Loaded drops " + rewards.getDrops().stream().map(Object::toString).collect(Collectors.joining());
    }
}

