/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.preset.condition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.aurorion.blockregen.ParseException;
import nl.aurorion.blockregen.conditional.Condition;
import nl.aurorion.blockregen.conditional.ConditionContext;
import nl.aurorion.blockregen.preset.condition.ConditionProvider;
import nl.aurorion.blockregen.preset.condition.ConditionRelation;
import nl.aurorion.blockregen.preset.condition.ConditionWrapper;
import nl.aurorion.blockregen.preset.condition.ContextExtender;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class Conditions {
    @NotNull
    public static Condition fromNode(@NotNull Object node, @NotNull ConditionRelation relation, @NotNull ConditionProvider parser) {
        if (node instanceof List) {
            return Conditions.fromList((List)node, relation, parser);
        }
        if (node instanceof Map) {
            return Conditions.fromMap((Map)node, relation, parser);
        }
        if (node instanceof ConfigurationSection) {
            return Conditions.fromMap(((ConfigurationSection)node).getValues(false), relation, parser);
        }
        return parser.load(null, node);
    }

    @NotNull
    public static Condition fromNodeMultiple(@NotNull Object node, @NotNull ConditionRelation relation, @NotNull ConditionProvider parser) {
        if (node instanceof List) {
            return Conditions.fromList((List)node, relation, parser);
        }
        if (node instanceof Map) {
            return Conditions.fromMap((Map)node, relation, parser);
        }
        if (node instanceof ConfigurationSection) {
            return Conditions.fromMap(((ConfigurationSection)node).getValues(false), relation, parser);
        }
        throw new ParseException("Node cannot be loaded from a single value.");
    }

    @NotNull
    public static Condition fromList(@NotNull List<?> nodes, @NotNull ConditionRelation relation, @NotNull ConditionProvider parser) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (Object node : nodes) {
            Condition condition;
            if (node instanceof Map) {
                Map values = (Map)node;
                condition = Conditions.fromMap(values, ConditionRelation.AND, parser);
            } else {
                condition = parser.load(null, node);
            }
            conditions.add(condition);
        }
        return relation == ConditionRelation.OR ? Condition.anyOf(conditions) : Condition.allOf(conditions);
    }

    @NotNull
    public static Condition fromMap(@NotNull Map<String, Object> values, @NotNull ConditionRelation relation, @NotNull ConditionProvider parser) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Condition condition;
            boolean negate = false;
            String key = entry.getKey();
            if (key.startsWith("^")) {
                key = key.substring(1);
                negate = true;
            }
            if (key.equalsIgnoreCase("all") || key.equalsIgnoreCase("any")) {
                if (!(entry.getValue() instanceof List)) {
                    throw new ParseException("Invalid entry for all/any section.");
                }
                List stackedNodes = (List)entry.getValue();
                condition = Conditions.fromList(stackedNodes, key.equalsIgnoreCase("any") ? ConditionRelation.OR : ConditionRelation.AND, parser);
            } else {
                condition = parser.load(key, entry.getValue());
            }
            if (negate) {
                condition = condition.negate();
            }
            conditions.add(condition);
        }
        return relation == ConditionRelation.OR ? Condition.anyOf(conditions) : Condition.allOf(conditions);
    }

    @NotNull
    public static ConditionContext mergeContexts(ConditionContext ... contexts) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (ConditionContext context : contexts) {
            Map<String, Object> vars = context.values();
            result.putAll(vars);
        }
        return ConditionContext.of(result);
    }

    @NotNull
    public static ConditionWrapper wrap(@NotNull Condition condition, @NotNull ContextExtender extender) {
        return new ConditionWrapper(condition, extender);
    }
}

