/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.preset.condition.expression;

import com.google.common.base.Strings;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import nl.aurorion.blockregen.ParseException;
import nl.aurorion.blockregen.conditional.ConditionContext;
import nl.aurorion.blockregen.preset.condition.expression.Constant;
import nl.aurorion.blockregen.preset.condition.expression.Variable;
import org.jetbrains.annotations.NotNull;

public interface Operand {
    public static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(%\\S+%)");

    public Object value(ConditionContext var1);

    public static class Parser {
        @Generated
        private static final Logger log = Logger.getLogger(Parser.class.getName());

        @NotNull
        public static Object parseObject(String input) {
            try {
                return Integer.parseInt(input);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.parseDouble(input);
                }
                catch (NumberFormatException numberFormatException2) {
                    try {
                        return LocalTime.parse(input, DateTimeFormatter.ofPattern("H:m:s"));
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        return input;
                    }
                }
            }
        }

        @NotNull
        static Operand parse(@NotNull String input) {
            if (Strings.isNullOrEmpty((String)input)) {
                throw new ParseException("Input cannot be null or empty");
            }
            String trimmed = input.trim();
            Matcher matcher = PLACEHOLDER_PATTERN.matcher(trimmed);
            if (matcher.find()) {
                return new Variable(matcher.group(1));
            }
            Object v = Parser.parseObject(trimmed);
            return new Constant(v);
        }
    }
}

