/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.preset.condition.expression;

import java.time.LocalTime;
import java.util.Objects;
import lombok.Generated;
import nl.aurorion.blockregen.preset.condition.expression.TypedComparisons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OperandRelation {
    GTE(">=", TypedComparisons.of(Number.class, (num1, num2) -> num1.doubleValue() >= num2.doubleValue()).add(LocalTime.class, (t1, t2) -> t1.equals(t2) || t1.isAfter((LocalTime)t2))),
    LTE("<=", TypedComparisons.of(Number.class, (num1, num2) -> num1.doubleValue() <= num2.doubleValue()).add(LocalTime.class, (t1, t2) -> t1.equals(t2) || t1.isBefore((LocalTime)t2))),
    EQ("==", TypedComparisons.of(Number.class, Objects::equals).add(LocalTime.class, Objects::equals).add(String.class, Objects::equals)),
    NEQ("!=", TypedComparisons.of(Number.class, (num1, num2) -> num1.doubleValue() != num2.doubleValue()).add(LocalTime.class, (t1, t2) -> !Objects.equals(t1, t2)).add(String.class, (a, b) -> !Objects.equals(a, b))),
    LT("<", TypedComparisons.of(Number.class, (num1, num2) -> num1.doubleValue() < num2.doubleValue()).add(LocalTime.class, LocalTime::isBefore)),
    GT(">", TypedComparisons.of(Number.class, (num1, num2) -> num1.doubleValue() > num2.doubleValue()).add(LocalTime.class, LocalTime::isAfter));

    private final String symbol;
    private final TypedComparisons comparisons;

    private OperandRelation(String symbol, TypedComparisons comparisons) {
        this.symbol = symbol;
        this.comparisons = comparisons;
    }

    @Nullable
    public static OperandRelation parse(String input) {
        for (OperandRelation relation : OperandRelation.values()) {
            if (!relation.symbol.equalsIgnoreCase(input)) continue;
            return relation;
        }
        return null;
    }

    boolean evaluate(@NotNull Object o1, @NotNull Object o2) {
        return this.comparisons.parse(o1, o2);
    }

    public String toString() {
        return "OperandRelation{symbol='" + this.symbol + '\'' + '}';
    }

    @Generated
    public String getSymbol() {
        return this.symbol;
    }
}

