/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.preset.drop;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.util.Parsing;
import nl.aurorion.blockregen.xseries.XEnchantment;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Enchant {
    @Generated
    private static final Logger log = Logger.getLogger(Enchant.class.getName());
    private final XEnchantment enchantment;
    private final int level;

    public Enchant(XEnchantment enchantment, int level) {
        this.enchantment = enchantment;
        this.level = level;
    }

    @NotNull
    public static Enchant from(String str) {
        String[] arr;
        String enchantString = str;
        int level = 1;
        if (str.contains(":") && (arr = str.split(":")).length == 2) {
            enchantString = arr[0];
            level = Parsing.parseInt(arr[1], 1);
        }
        XEnchantment xEnchantment = Parsing.parseEnchantment(enchantString);
        return new Enchant(xEnchantment, level);
    }

    @NotNull
    public static Set<Enchant> loadSet(@NotNull List<String> input) {
        HashSet<Enchant> out = new HashSet<Enchant>();
        for (String str : input) {
            Enchant enchant = Enchant.from(str);
            out.add(enchant);
        }
        return out;
    }

    public void apply(@Nullable ItemMeta meta) {
        if (meta == null) {
            return;
        }
        Enchantment enchantment = (Enchantment)this.enchantment.get();
        if (enchantment == null) {
            log.warning("Unable to parse XEnchantment '" + this.enchantment + "' to this version.");
            return;
        }
        meta.addEnchant(enchantment, this.level, true);
    }

    @Generated
    public XEnchantment getEnchantment() {
        return this.enchantment;
    }

    @Generated
    public int getLevel() {
        return this.level;
    }
}

