/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.preset.material;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import nl.aurorion.blockregen.material.BlockRegenMaterial;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;

public class TargetMaterial {
    private final List<BlockRegenMaterial> materials;

    private TargetMaterial(Collection<BlockRegenMaterial> materials) {
        this.materials = new ArrayList<BlockRegenMaterial>(materials);
    }

    private TargetMaterial(BlockRegenMaterial material) {
        this.materials = new ArrayList<BlockRegenMaterial>();
        this.materials.add(material);
    }

    @NotNull
    public static TargetMaterial of(@NotNull BlockRegenMaterial material) {
        return new TargetMaterial(material);
    }

    @NotNull
    public static TargetMaterial of(@NotNull Collection<BlockRegenMaterial> materials) {
        return new TargetMaterial(materials);
    }

    public boolean matches(@NotNull Block block) {
        for (BlockRegenMaterial targetMaterial : this.materials) {
            if (!targetMaterial.check(block)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "TargetMaterial{materials=" + this.materials + '}';
    }

    @Generated
    public List<BlockRegenMaterial> getMaterials() {
        return this.materials;
    }
}

