/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.regeneration;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.TownBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.Message;
import nl.aurorion.blockregen.ParseException;
import nl.aurorion.blockregen.api.BlockRegenBlockBreakEvent;
import nl.aurorion.blockregen.conditional.ConditionContext;
import nl.aurorion.blockregen.event.struct.PresetEvent;
import nl.aurorion.blockregen.preset.BlockPreset;
import nl.aurorion.blockregen.preset.drop.DropItem;
import nl.aurorion.blockregen.preset.drop.ExperienceDrop;
import nl.aurorion.blockregen.regeneration.EventControl;
import nl.aurorion.blockregen.regeneration.RegenerationEventHandler;
import nl.aurorion.blockregen.regeneration.RegenerationEventType;
import nl.aurorion.blockregen.regeneration.struct.RegenerationProcess;
import nl.aurorion.blockregen.region.struct.RegenerationArea;
import nl.aurorion.blockregen.util.Blocks;
import nl.aurorion.blockregen.util.Items;
import nl.aurorion.blockregen.util.Locations;
import nl.aurorion.blockregen.util.Permissions;
import nl.aurorion.blockregen.util.Text;
import nl.aurorion.blockregen.xseries.XBlock;
import nl.aurorion.blockregen.xseries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegenerationEventHandlerImpl
implements RegenerationEventHandler {
    @Generated
    private static final Logger log = Logger.getLogger(RegenerationEventHandlerImpl.class.getName());
    private final BlockRegenPlugin plugin;

    public RegenerationEventHandlerImpl(BlockRegenPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public <E extends Event> void handleEvent(Block block, Player player, E event, EventControl<E> eventControl, RegenerationEventType type) {
        XMaterial aboveType;
        boolean isConfigured;
        boolean isInZone;
        RegenerationProcess existingProcess = this.plugin.getRegenerationManager().getProcess(block);
        if (existingProcess != null) {
            if (this.hasBypass(player)) {
                this.plugin.getRegenerationManager().removeProcess(existingProcess);
                log.fine(() -> "Removed process in bypass.");
                return;
            }
            if (existingProcess.getRegenerationTime() > System.currentTimeMillis()) {
                log.fine(() -> String.format("Block is regenerating. Process: %s", existingProcess));
                eventControl.cancel();
                return;
            }
        }
        if (this.hasBypass(player)) {
            log.fine(() -> "Player has bypass.");
            return;
        }
        if (this.plugin.getRegenerationManager().hasDataCheck(player)) {
            eventControl.cancel();
            log.fine(() -> "Player has block check.");
            return;
        }
        if (this.checkProtection(player, block, type)) {
            return;
        }
        World world = block.getWorld();
        boolean useRegions = this.plugin.getConfig().getBoolean("Use-Regions", false);
        RegenerationArea area = this.plugin.getRegionManager().getArea(block);
        boolean isInWorld = this.plugin.getConfig().getStringList("Worlds-Enabled").contains(world.getName());
        boolean isInArea = area != null;
        boolean bl = isInZone = useRegions ? isInArea : isInWorld;
        if (!isInZone) {
            return;
        }
        log.fine(() -> String.format("Handling %s.", Locations.locationToString(block.getLocation())));
        BlockPreset preset = this.plugin.getPresetManager().getPreset(block, area);
        boolean bl2 = isConfigured = preset != null;
        if (!isConfigured) {
            if (this.plugin.getConfig().getBoolean("Disable-Other-Break")) {
                eventControl.cancel();
                log.fine(() -> String.format("%s is not a configured preset. Denied block break.", block.getType()));
                return;
            }
            log.fine(() -> String.format("%s is not a configured preset.", block.getType()));
            return;
        }
        if (isInArea && Permissions.lacksPermission(player, "blockregen.region", area.getName()) && !player.isOp()) {
            eventControl.cancel();
            Message.PERMISSION_REGION_ERROR.send(player);
            log.fine(() -> String.format("Player doesn't have permissions for region %s", area.getName()));
            return;
        }
        if (Permissions.lacksPermission(player, "blockregen.block", block.getType().toString()) && !player.isOp()) {
            Message.PERMISSION_BLOCK_ERROR.send(player);
            eventControl.cancel();
            log.fine(() -> String.format("Player doesn't have permission for block %s.", block.getType()));
            return;
        }
        if (Permissions.lacksPermission(player, "blockregen.preset", preset.getName()) && !player.isOp()) {
            Message.PERMISSION_BLOCK_ERROR.send(player);
            eventControl.cancel();
            log.fine(() -> String.format("Player doesn't have permission for preset %s.", preset.getName()));
            return;
        }
        if (!preset.getConditions().check(player)) {
            eventControl.cancel();
            log.fine(() -> "Player doesn't meet conditions.");
            return;
        }
        ConditionContext ctx = ConditionContext.empty().with("player", player).with("tool", this.plugin.getVersionManager().getMethods().getItemInMainHand(player)).with("block", block);
        try {
            if (!preset.getCondition().matches(ctx)) {
                eventControl.cancel();
                log.fine(() -> "Player doesn't meet conditions.");
                return;
            }
        }
        catch (ParseException e) {
            log.warning("Failed to run conditions for preset " + preset.getName() + ": " + e.getMessage());
            eventControl.cancel();
            return;
        }
        BlockRegenBlockBreakEvent blockRegenBlockBreakEvent = new BlockRegenBlockBreakEvent(block, preset, event, type, area);
        Bukkit.getServer().getPluginManager().callEvent((Event)blockRegenBlockBreakEvent);
        if (blockRegenBlockBreakEvent.isCancelled()) {
            log.fine(() -> "BlockRegenBreakEvent got cancelled.");
            return;
        }
        int vanillaExperience = eventControl.getDefaultExperience();
        eventControl.cancelDrops();
        if (event instanceof PlayerHarvestBlockEvent) {
            PlayerHarvestBlockEvent e = (PlayerHarvestBlockEvent)event;
            log.fine(String.format("drop count: %d", e.getItemsHarvested().size()));
        }
        if (Blocks.isMultiblockCrop(this.plugin, block) && preset.isHandleCrops()) {
            this.handleMultiblockCrop(block, player, preset, area, vanillaExperience);
            return;
        }
        Block above = block.getRelative(BlockFace.UP);
        log.fine(() -> "Above: " + above.getType());
        BlockPreset abovePreset = this.plugin.getPresetManager().getPreset(above, area);
        if (abovePreset != null && abovePreset.isHandleCrops() && (aboveType = this.plugin.getBlockType(above)) != null) {
            if (Blocks.isMultiblockCrop(aboveType)) {
                this.handleMultiblockCrop(above, player, abovePreset, area, vanillaExperience);
            } else if (XBlock.isCrop(aboveType) || Blocks.reliesOnBlockBelow(aboveType)) {
                log.fine(() -> "Handling block above...");
                ArrayList<ItemStack> vanillaDrops = new ArrayList<ItemStack>(above.getDrops(this.plugin.getVersionManager().getMethods().getItemInMainHand(player)));
                RegenerationProcess process = this.plugin.getRegenerationManager().createProcess(above, abovePreset, area);
                process.start();
                this.handleRewards(above.getState(), abovePreset, player, vanillaDrops, 0);
            }
        }
        RegenerationProcess process = this.plugin.getRegenerationManager().createProcess(block, preset, area);
        this.handleBreak(process, preset, block, player, vanillaExperience);
    }

    private boolean checkProtection(Player player, Block block, RegenerationEventType type) {
        TownBlock townBlock;
        if (this.plugin.getConfig().getBoolean("Towny-Support", true) && this.plugin.getServer().getPluginManager().getPlugin("Towny") != null && (townBlock = TownyAPI.getInstance().getTownBlock(block.getLocation())) != null && townBlock.hasTown()) {
            log.fine(() -> "Let Towny handle this.");
            return true;
        }
        if (this.plugin.getConfig().getBoolean("GriefPrevention-Support", true) && this.plugin.getCompatibilityManager().getGriefPrevention().isLoaded()) {
            this.plugin.getCompatibilityManager().getGriefPrevention().get().canBreak(block, player);
        }
        if (this.plugin.getConfig().getBoolean("WorldGuard-Support", true) && this.plugin.getVersionManager().getWorldGuardProvider() != null) {
            if (type == RegenerationEventType.BLOCK_BREAK) {
                if (!this.plugin.getVersionManager().getWorldGuardProvider().canBreak(player, block.getLocation())) {
                    log.fine(() -> "Let WorldGuard handle block break.");
                    return true;
                }
            } else if (type == RegenerationEventType.TRAMPLING && !this.plugin.getVersionManager().getWorldGuardProvider().canTrample(player, block.getLocation())) {
                log.fine(() -> "Let WorldGuard handle trampling.");
                return true;
            }
        }
        if (this.plugin.getConfig().getBoolean("Residence-Support", true) && this.plugin.getCompatibilityManager().getResidence().isLoaded()) {
            this.plugin.getCompatibilityManager().getResidence().get().canBreak(block, player, type);
        }
        return false;
    }

    private boolean hasBypass(Player player) {
        return this.plugin.getRegenerationManager().hasBypass(player) || this.plugin.getConfig().getBoolean("Bypass-In-Creative", false) && player.getGameMode() == GameMode.CREATIVE;
    }

    private void handleMultiblockCrop(Block block, Player player, BlockPreset preset, @Nullable RegenerationArea area, int vanillaExp) {
        Block base;
        boolean regenerateWhole = preset.isRegenerateWhole();
        this.handleMultiblockAbove(block, player, above -> Blocks.isMultiblockCrop(this.plugin, above), (b, abovePreset) -> {
            if (regenerateWhole && abovePreset != null && abovePreset.isHandleCrops()) {
                RegenerationProcess process = this.plugin.getRegenerationManager().createProcess((Block)b, (BlockPreset)abovePreset, area);
                process.start();
            } else {
                b.setType(Material.AIR);
            }
        }, area);
        try {
            base = this.findBase(block);
        }
        catch (IllegalArgumentException e) {
            log.fine(() -> "handleMultiBlockCrop: " + e.getMessage());
            if (!this.plugin.getConfig().getBoolean("Ignore-Unknown-Materials", false)) {
                throw e;
            }
            return;
        }
        log.fine(() -> "Base " + Blocks.blockToString(base));
        RegenerationProcess process = null;
        if (block == base || regenerateWhole) {
            process = this.plugin.getRegenerationManager().createProcess(block, preset, area);
        }
        this.handleBreak(process, preset, block, player, vanillaExp);
    }

    private Block findBase(Block block) {
        Block below = block.getRelative(BlockFace.DOWN);
        XMaterial belowType = this.plugin.getVersionManager().getMethods().getType(below);
        XMaterial type = this.plugin.getVersionManager().getMethods().getType(block);
        if (Blocks.isKelp(type)) {
            if (!Blocks.isKelp(belowType)) {
                return block;
            }
            return this.findBase(below);
        }
        if (type != belowType) {
            return block;
        }
        return this.findBase(below);
    }

    private void handleMultiblockAbove(Block block, Player player, Predicate<Block> filter, BiConsumer<Block, BlockPreset> startProcess, RegenerationArea area) {
        Block above = block.getRelative(BlockFace.UP);
        if (filter.test(above)) {
            this.handleMultiblockAbove(above, player, filter, startProcess, area);
            BlockPreset abovePreset = this.plugin.getPresetManager().getPreset(above, area);
            if (abovePreset != null) {
                ArrayList<ItemStack> vanillaDrops = new ArrayList<ItemStack>(block.getDrops(this.plugin.getVersionManager().getMethods().getItemInMainHand(player)));
                startProcess.accept(above, abovePreset);
                this.handleRewards(above.getState(), abovePreset, player, vanillaDrops, 0);
            }
        }
    }

    private void handleBreak(@Nullable RegenerationProcess process, BlockPreset preset, Block block, Player player, int vanillaExperience) {
        BlockState state = block.getState();
        ArrayList<ItemStack> vanillaDrops = new ArrayList<ItemStack>(block.getDrops(this.plugin.getVersionManager().getMethods().getItemInMainHand(player)));
        if (this.plugin.getVersionManager().isCurrentBelow("1.8", true)) {
            block.setType(Material.AIR);
        }
        if (process != null) {
            process.start();
        }
        this.handleRewards(state, preset, player, vanillaDrops, vanillaExperience);
    }

    private void handleRewards(BlockState state, BlockPreset preset, Player player, List<ItemStack> vanillaDrops, int vanillaExperience) {
        Block block = state.getBlock();
        Function<String, String> parser = str -> Text.parse(str, player, block);
        ConditionContext ctx = ConditionContext.empty().with("player", player).with("tool", this.plugin.getVersionManager().getMethods().getItemInMainHand(player)).with("block", block);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            HashMap<ItemStack, Boolean> drops = new HashMap<ItemStack, Boolean>();
            AtomicInteger experience = new AtomicInteger(0);
            if (preset.isNaturalBreak()) {
                for (ItemStack itemStack : vanillaDrops) {
                    drops.put(itemStack, preset.isDropNaturally());
                }
                experience.addAndGet(vanillaExperience);
            } else {
                for (DropItem dropItem : preset.getRewards().getDrops()) {
                    ItemStack itemStack;
                    log.fine(dropItem.getCondition() + " " + dropItem.getCondition().matches(ctx));
                    if (!dropItem.getCondition().matches(ctx) || !dropItem.shouldDrop() || (itemStack = dropItem.toItemStack(parser)) == null) continue;
                    if (dropItem.isApplyFortune()) {
                        itemStack.setAmount(Items.applyFortune(block.getType(), this.plugin.getVersionManager().getMethods().getItemInMainHand(player)) + itemStack.getAmount());
                    }
                    drops.put(itemStack, dropItem.isDropNaturally());
                    ExperienceDrop experienceDrop = dropItem.getExperienceDrop();
                    if (experienceDrop == null) continue;
                    experience.addAndGet(experienceDrop.getAmount().getInt());
                }
            }
            PresetEvent presetEvent = this.plugin.getEventManager().getEvent(preset.getName());
            if (presetEvent != null && presetEvent.isEnabled()) {
                if (presetEvent.isDoubleDrops()) {
                    drops.keySet().forEach(drop -> drop.setAmount(drop.getAmount() * 2));
                }
                if (presetEvent.isDoubleExperience()) {
                    experience.set(experience.get() * 2);
                }
                if (this.plugin.getRandom().nextInt(presetEvent.getItemRarity().getInt()) == 0) {
                    ItemStack eventStack;
                    DropItem dropItem = presetEvent.getItem();
                    if (dropItem != null && dropItem.shouldDrop() && dropItem.getCondition().matches(ctx) && (eventStack = dropItem.toItemStack(parser)) != null) {
                        drops.put(eventStack, dropItem.isDropNaturally());
                    }
                    for (DropItem drop3 : presetEvent.getRewards().getDrops()) {
                        ItemStack item;
                        if (!drop3.shouldDrop() || !drop3.getCondition().matches(ctx) || (item = drop3.toItemStack(parser)) == null) continue;
                        drops.put(item, drop3.isDropNaturally());
                    }
                    presetEvent.getRewards().give(player, parser);
                }
            }
            this.giveItems(drops, state, player);
            this.giveExp(block.getLocation(), player, experience.get(), preset.isDropNaturally(), preset.isApplyMending());
            if (this.plugin.getConfig().getBoolean("Jobs-Rewards", false) && this.plugin.getCompatibilityManager().getJobs().isLoaded()) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getCompatibilityManager().getJobs().get().triggerBlockBreakAction(player, block));
            }
            preset.getRewards().give(player, str -> Text.replace(Text.parse(str, player, block), "earned_experience", experience.get()));
            if (preset.getSound() != null) {
                preset.getSound().play(block.getLocation());
            }
            if (preset.getParticle() != null && this.plugin.getVersionManager().isCurrentAbove("1.8", false)) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getParticleManager().displayParticle(preset.getParticle(), block));
            }
        });
    }

    private void spawnExp(Location location, int amount) {
        if (location.getWorld() == null) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> ((ExperienceOrb)location.getWorld().spawn(location, ExperienceOrb.class)).setExperience(amount));
        log.fine(() -> String.format("Spawning xp (%d).", amount));
    }

    private void giveExp(@NotNull Location location, @NotNull Player player, int amount, boolean naturally, boolean applyMending) {
        if (amount <= 0) {
            return;
        }
        if (naturally) {
            this.spawnExp(location, amount);
        } else if (applyMending) {
            int remainingExperience = this.plugin.getVersionManager().getMethods().applyMending(player, amount);
            player.giveExp(remainingExperience);
        } else {
            player.giveExp(amount);
        }
    }

    private void giveItems(Map<ItemStack, Boolean> itemStacks, BlockState blockState, Player player) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            ArrayList<Item> items = new ArrayList<Item>();
            for (Map.Entry entry : itemStacks.entrySet()) {
                ItemStack item = (ItemStack)entry.getKey();
                if (((Boolean)entry.getValue()).booleanValue()) {
                    log.fine(() -> "Dropping item " + item.getType() + "x" + item.getAmount());
                    items.add(blockState.getWorld().dropItemNaturally(blockState.getLocation().clone().add(0.5, 0.5, 0.5), item));
                    continue;
                }
                log.fine(() -> "Giving item " + item.getType() + "x" + item.getAmount());
                HashMap left = player.getInventory().addItem(new ItemStack[]{item});
                if (left.isEmpty()) continue;
                if (this.plugin.getConfig().getBoolean("Drop-Items-When-Full", true)) {
                    log.fine(() -> "Inventory full. Dropping item on the ground.");
                    Message.INVENTORY_FULL_DROPPED.send(player);
                    ItemStack leftStack = (ItemStack)left.get(left.keySet().iterator().next());
                    items.add(player.getWorld().dropItemNaturally(player.getLocation(), leftStack));
                    continue;
                }
                Message.INVENTORY_FULL_LOST.send(player);
            }
            this.plugin.getVersionManager().getMethods().handleDropItemEvent(player, blockState, items);
        });
    }
}

