/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.regeneration.struct;

import java.util.Objects;
import java.util.UUID;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.BlockRegenPluginImpl;
import nl.aurorion.blockregen.api.BlockRegenBlockRegenerationEvent;
import nl.aurorion.blockregen.material.BlockRegenMaterial;
import nl.aurorion.blockregen.material.MinecraftMaterial;
import nl.aurorion.blockregen.preset.BlockPreset;
import nl.aurorion.blockregen.preset.FixedNumberValue;
import nl.aurorion.blockregen.regeneration.struct.SimpleLocation;
import nl.aurorion.blockregen.util.Blocks;
import nl.aurorion.blockregen.util.Locations;
import nl.aurorion.blockregen.version.api.NodeData;
import nl.aurorion.blockregen.xseries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class RegenerationProcess {
    @Generated
    private static final Logger log = Logger.getLogger(RegenerationProcess.class.getName());
    private final UUID id = UUID.randomUUID();
    private SimpleLocation location;
    private transient Block block;
    private XMaterial originalMaterial;
    private NodeData originalData;
    private String regionName;
    private String worldName;
    private String presetName;
    private transient BlockPreset preset;
    private transient long regenerationTime;
    private transient BlockRegenMaterial replaceMaterial;
    private long timeLeft = -1L;
    private transient BlockRegenMaterial regenerateInto;
    private transient BukkitTask task;

    public RegenerationProcess(Block block, NodeData originalData, BlockPreset preset) {
        this.block = block;
        this.location = new SimpleLocation(block);
        this.preset = preset;
        this.presetName = preset.getName();
        this.worldName = block.getWorld().getName();
        this.originalData = originalData;
        this.originalMaterial = BlockRegenPlugin.getInstance().getVersionManager().getMethods().getType(block);
    }

    public boolean start() {
        this.stop();
        BlockRegenPlugin plugin = BlockRegenPluginImpl.getInstance();
        plugin.getRegenerationManager().registerProcess(this);
        if (this.shouldRegenerate()) {
            if (this.timeLeft == -1L) {
                int regenDelay = this.preset.getDelay().getInt();
                this.timeLeft = (long)regenDelay * 1000L;
            }
            this.regenerationTime = System.currentTimeMillis() + this.timeLeft;
            if (this.timeLeft == 0L || this.regenerationTime <= System.currentTimeMillis()) {
                Bukkit.getScheduler().runTask((Plugin)plugin, this::regenerate);
                log.fine(() -> "Regenerated the process upon start.");
                return false;
            }
        }
        Bukkit.getScheduler().runTask((Plugin)plugin, this::replaceBlock);
        if (!this.shouldRegenerate()) {
            return true;
        }
        this.startTask();
        return true;
    }

    public boolean shouldRegenerate() {
        return !(this.preset.getDelay() instanceof FixedNumberValue) || this.preset.getDelay().getInt() >= 0;
    }

    private void startTask() {
        this.task = Bukkit.getScheduler().runTaskLater((Plugin)BlockRegenPluginImpl.getInstance(), this::regenerate, this.timeLeft / 50L);
        log.fine(() -> String.format("Regenerate %s in %ds", this, this.timeLeft / 1000L));
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    public void regenerate() {
        log.fine(() -> "Regenerating " + this + "...");
        if (this.task != null) {
            this.task.cancel();
        }
        BlockRegenPlugin plugin = BlockRegenPluginImpl.getInstance();
        BlockRegenMaterial regenerateInto = this.getRegenerateInto();
        if (regenerateInto.requiresSolidGround() && this.preset.isCheckSolidGround()) {
            Block below = this.block.getRelative(BlockFace.DOWN);
            XMaterial belowType = plugin.getVersionManager().getMethods().getType(below);
            RegenerationProcess processBelow = plugin.getRegenerationManager().getProcess(below);
            if (!(below.getType().isSolid() || belowType == XMaterial.SUGAR_CANE || Blocks.isKelp(belowType) || Blocks.isSeagrass(belowType))) {
                if (processBelow != null) {
                    long delay;
                    this.timeLeft = delay = processBelow.getRegenerationTime() >= this.getRegenerationTime() ? processBelow.getRegenerationTime() - this.getRegenerationTime() + 100L : 1000L;
                    this.regenerationTime = System.currentTimeMillis() + this.timeLeft;
                    log.fine(() -> "Delaying " + this + " to wait for " + processBelow + " delay: " + delay);
                    this.startTask();
                } else {
                    log.fine(() -> "No block under " + this + ", no point regenerating.");
                    plugin.getRegenerationManager().removeProcess(this);
                }
                return;
            }
        }
        BlockRegenBlockRegenerationEvent blockRegenBlockRegenEvent = new BlockRegenBlockRegenerationEvent(this);
        Bukkit.getPluginManager().callEvent((Event)blockRegenBlockRegenEvent);
        plugin.getRegenerationManager().removeProcess(this);
        if (blockRegenBlockRegenEvent.isCancelled()) {
            return;
        }
        this.regenerateBlock();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            if (this.preset.getRegenerationParticle() != null) {
                plugin.getParticleManager().displayParticle(this.preset.getRegenerationParticle(), this.block);
            }
        });
        this.task = null;
    }

    public void regenerateBlock() {
        BlockRegenMaterial regenerateInto = this.getRegenerateInto();
        if (regenerateInto.requiresFarmland()) {
            Block under = this.block.getRelative(BlockFace.DOWN);
            XMaterial underType = BlockRegenPluginImpl.getInstance().getVersionManager().getMethods().getType(under);
            if (underType != XMaterial.FARMLAND) {
                under.setType(Objects.requireNonNull(XMaterial.FARMLAND.get()));
            }
        }
        regenerateInto.setType(this.block);
        if (regenerateInto.applyOriginalData()) {
            this.originalData.apply(this.block);
        }
        regenerateInto.applyData(this.block);
        log.fine(() -> "Regenerated " + this);
    }

    public void revert() {
        this.stop();
        BlockRegenPlugin plugin = BlockRegenPluginImpl.getInstance();
        plugin.getRegenerationManager().removeProcess(this);
        this.revertBlock();
    }

    public void revertBlock() {
        BlockRegenMaterial original = this.getOriginalMaterial();
        if (Blocks.requiresFarmland(this.originalMaterial)) {
            Block under = this.block.getRelative(BlockFace.DOWN);
            XMaterial underType = BlockRegenPluginImpl.getInstance().getVersionManager().getMethods().getType(under);
            if (underType != XMaterial.FARMLAND) {
                under.setType(Objects.requireNonNull(XMaterial.FARMLAND.get()));
            }
        }
        original.place(this.block);
        log.fine(() -> String.format("Reverted block for %s", this));
    }

    public void replaceBlock() {
        BlockRegenMaterial replaceMaterial = this.getReplaceMaterial();
        if (replaceMaterial.requiresFarmland()) {
            Block under = this.block.getRelative(BlockFace.DOWN);
            XMaterial underType = BlockRegenPluginImpl.getInstance().getVersionManager().getMethods().getType(under);
            if (underType != XMaterial.FARMLAND) {
                under.setType(Objects.requireNonNull(XMaterial.FARMLAND.get()));
            }
        }
        replaceMaterial.setType(this.block);
        if (replaceMaterial.applyOriginalData()) {
            this.originalData.apply(this.block);
        }
        replaceMaterial.applyData(this.block);
        Bukkit.getScheduler().runTaskLater((Plugin)BlockRegenPluginImpl.getInstance(), () -> this.block.getState().update(true), 1L);
        log.fine(() -> "Replaced block for " + this);
    }

    @NotNull
    public BlockRegenMaterial getRegenerateInto() {
        if (this.regenerateInto == null) {
            this.regenerateInto = this.preset.getRegenMaterial() == null ? new MinecraftMaterial(BlockRegenPlugin.getInstance(), this.originalMaterial, this.originalData) : this.preset.getRegenMaterial().get();
        }
        return this.regenerateInto;
    }

    @NotNull
    public BlockRegenMaterial getReplaceMaterial() {
        if (this.replaceMaterial == null) {
            this.replaceMaterial = this.preset.getReplaceMaterial() == null ? new MinecraftMaterial(BlockRegenPluginImpl.getInstance(), XMaterial.AIR, null) : this.preset.getReplaceMaterial().get();
        }
        return this.replaceMaterial;
    }

    @NotNull
    public BlockRegenMaterial getOriginalMaterial() {
        return new MinecraftMaterial(BlockRegenPluginImpl.getInstance(), this.originalMaterial, this.originalData);
    }

    public boolean convertLocation() {
        if (this.location == null) {
            log.severe("Could not load location for process " + this);
            return false;
        }
        Block block = this.location.toBlock();
        if (block == null) {
            log.severe("Could not load location for process " + this + ", world is invalid or not loaded.");
            return false;
        }
        Bukkit.getScheduler().runTask((Plugin)BlockRegenPluginImpl.getInstance(), () -> {
            this.block = block;
        });
        return true;
    }

    public boolean convertPreset() {
        BlockRegenPlugin plugin = BlockRegenPluginImpl.getInstance();
        BlockPreset preset = plugin.getPresetManager().getPreset(this.presetName);
        if (preset == null) {
            log.severe("Could not load process " + this + ", it's preset '" + this.presetName + "' is invalid.");
            return false;
        }
        this.preset = preset;
        return true;
    }

    public void updateTimeLeft(long timeLeft) {
        this.timeLeft = timeLeft;
        if (timeLeft > 0L) {
            this.start();
        } else if (timeLeft == 0L) {
            this.regenerate();
        }
    }

    public boolean isRunning() {
        return this.task != null;
    }

    public Block getBlock() {
        if (this.block == null) {
            this.convertLocation();
        }
        return this.block;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegenerationProcess process = (RegenerationProcess)o;
        return process.getLocation().equals(this.getLocation());
    }

    public int hashCode() {
        return Objects.hashCode(this.location);
    }

    public String toString() {
        return String.format("{id=%s; task=%s; presetName=%s; worldName=%s; regionName=%s; block=%s; originalData=%s; originalMaterial=%s; regenerateInto=%s; replaceMaterial=%s; timeLeft=%d; regenerationTime=%d}", this.id, this.task == null ? "null" : Integer.valueOf(this.task.getTaskId()), this.presetName, this.worldName, this.regionName, this.block == null ? "null" : Locations.locationToString(this.block.getLocation()), this.originalData, this.originalMaterial, this.regenerateInto, this.replaceMaterial, this.timeLeft, this.regenerationTime);
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public SimpleLocation getLocation() {
        return this.location;
    }

    @Generated
    public String getPresetName() {
        return this.presetName;
    }

    @Generated
    public BukkitTask getTask() {
        return this.task;
    }

    @Generated
    public void setLocation(SimpleLocation location) {
        this.location = location;
    }

    @Generated
    public void setBlock(Block block) {
        this.block = block;
    }

    @Generated
    public void setOriginalMaterial(XMaterial originalMaterial) {
        this.originalMaterial = originalMaterial;
    }

    @Generated
    public void setOriginalData(NodeData originalData) {
        this.originalData = originalData;
    }

    @Generated
    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    @Generated
    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    @Generated
    public void setPresetName(String presetName) {
        this.presetName = presetName;
    }

    @Generated
    public void setPreset(BlockPreset preset) {
        this.preset = preset;
    }

    @Generated
    public void setRegenerationTime(long regenerationTime) {
        this.regenerationTime = regenerationTime;
    }

    @Generated
    public void setReplaceMaterial(BlockRegenMaterial replaceMaterial) {
        this.replaceMaterial = replaceMaterial;
    }

    @Generated
    public void setTimeLeft(long timeLeft) {
        this.timeLeft = timeLeft;
    }

    @Generated
    public void setTask(BukkitTask task) {
        this.task = task;
    }

    @Generated
    public NodeData getOriginalData() {
        return this.originalData;
    }

    @Generated
    public String getRegionName() {
        return this.regionName;
    }

    @Generated
    public String getWorldName() {
        return this.worldName;
    }

    @Generated
    public BlockPreset getPreset() {
        return this.preset;
    }

    @Generated
    public long getRegenerationTime() {
        return this.regenerationTime;
    }

    @Generated
    public long getTimeLeft() {
        return this.timeLeft;
    }

    @Generated
    public void setRegenerateInto(BlockRegenMaterial regenerateInto) {
        this.regenerateInto = regenerateInto;
    }
}

