/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.util;

import java.util.Map;

public class DiscreteGenerator<T> {
    private final Map<T, Double> probabilityFunction;

    private DiscreteGenerator(Map<T, Double> probabilityFunction) {
        this.probabilityFunction = probabilityFunction;
    }

    public static <T> DiscreteGenerator<T> fromProbabilityFunction(Map<T, Double> probabilityFunction) {
        double sum = probabilityFunction.values().stream().mapToDouble(e -> e).sum();
        if (Math.abs(sum - 1.0) > 1.0E-10) {
            throw new IllegalArgumentException(String.format("Chance of supplied items has to be equal to 100. (current value: %.2f)", sum * 100.0));
        }
        return new DiscreteGenerator<T>(probabilityFunction);
    }

    public T next() {
        double s = Math.random();
        T choice = null;
        for (Map.Entry<T, Double> entry : this.probabilityFunction.entrySet()) {
            s -= entry.getValue().doubleValue();
            choice = entry.getKey();
            if (!(s <= 0.0)) continue;
            break;
        }
        return choice;
    }
}

