/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.version;

import java.lang.reflect.Type;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.json.gson.Gson;
import nl.aurorion.blockregen.json.gson.GsonBuilder;
import nl.aurorion.blockregen.json.gson.JsonDeserializationContext;
import nl.aurorion.blockregen.json.gson.JsonDeserializer;
import nl.aurorion.blockregen.json.gson.JsonElement;
import nl.aurorion.blockregen.json.gson.JsonObject;
import nl.aurorion.blockregen.json.gson.JsonParseException;
import nl.aurorion.blockregen.json.gson.JsonPrimitive;
import nl.aurorion.blockregen.json.gson.JsonSerializationContext;
import nl.aurorion.blockregen.json.gson.JsonSerializer;
import nl.aurorion.blockregen.version.api.NodeData;

public class NodeDataAdapter<T extends NodeData>
implements JsonDeserializer<T>,
JsonSerializer<T> {
    @Generated
    private static final Logger log = Logger.getLogger(NodeDataAdapter.class.getName());
    private final Gson simpleGson = new GsonBuilder().setPrettyPrinting().create();

    @Override
    public T deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonPrimitive prim = (JsonPrimitive)jsonObject.get("className");
        String className = prim.getAsString();
        Class clazz = this.getClassInstance(className);
        log.fine(() -> String.format("Deserializing %s (%s) into %s", jsonElement, type, clazz.getName()));
        return (T)((NodeData)this.simpleGson.fromJson(jsonElement, clazz));
    }

    @Override
    public JsonElement serialize(T t, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonElement element = this.simpleGson.toJsonTree(t, type);
        element.getAsJsonObject().addProperty("className", t.getClass().getName());
        log.fine(() -> String.format("Serializing %s (%s) into %s", t, type, element));
        return element;
    }

    public Class<T> getClassInstance(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new JsonParseException(cnfe.getMessage());
        }
    }
}

