/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.version;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import nl.aurorion.blockregen.ParseException;
import nl.aurorion.blockregen.util.Parsing;
import nl.aurorion.blockregen.version.api.NodeData;
import org.jetbrains.annotations.NotNull;

public class NodeDataDeserializer<T extends NodeData> {
    @Generated
    private static final Logger log = Logger.getLogger(NodeDataDeserializer.class.getName());
    private static final Pattern DATA_PATTERN = Pattern.compile("\\[(.*)]");
    private static final Pattern KEY_PATTERN = Pattern.compile("^(.*?)=");
    private Pattern propertyEqualsPattern = null;
    private final Map<String, PropertyDeserializer<T>> properties = new HashMap<String, PropertyDeserializer<T>>();

    public static <E extends Enum<E>> E tryParseEnum(@NotNull String value, @NotNull Class<E> clazz) {
        Objects.requireNonNull(value, "Enum input cannot be null.");
        E face = Parsing.parseEnum(value.trim(), clazz);
        if (face == null) {
            try {
                int id = Integer.parseInt(value.trim());
                return (E)((Enum[])clazz.getEnumConstants())[id];
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                throw new ParseException(String.format("Invalid value '%s' for enum '%s'. Options: '%s'.", value, clazz.getSimpleName(), Arrays.stream((Enum[])clazz.getEnumConstants()).map(v -> v.name() + " (" + v.ordinal() + ")").collect(Collectors.joining("', '"))));
            }
        }
        return face;
    }

    @NotNull
    public NodeDataDeserializer<T> property(@NotNull String key, @NotNull PropertyDeserializer<T> deserializer) {
        this.properties.put(key.toLowerCase(), deserializer);
        return this;
    }

    @NotNull
    private Pattern generatePropertyEqualsPattern() {
        Set<String> properties = this.properties.keySet();
        return Pattern.compile(String.join((CharSequence)"|", properties), 2);
    }

    public void deserialize(@NotNull T nodeData, @NotNull String input) {
        String[] dataParts;
        Matcher matcher;
        log.fine(() -> "Deserializing " + input);
        if (this.propertyEqualsPattern == null) {
            this.propertyEqualsPattern = this.generatePropertyEqualsPattern();
        }
        if (!(matcher = DATA_PATTERN.matcher(input)).find()) {
            throw new ParseException("Malformed node data syntax. Most likely missing ']'.");
        }
        String dataString = matcher.group(1);
        for (String dataPart : dataParts = dataString.split(",")) {
            if (dataPart.trim().isEmpty()) {
                log.fine(() -> "Empty data part in '" + dataString + "'");
                continue;
            }
            Matcher keyMatcher = KEY_PATTERN.matcher(dataPart);
            if (!keyMatcher.find()) {
                throw new ParseException(String.format("Malformed node data property part '%s'. Skipping.", dataPart));
            }
            String key = keyMatcher.group(1).substring(0, keyMatcher.end() - 1);
            String value = dataPart.substring(keyMatcher.end());
            log.fine(() -> "Key: " + key + ", value: " + value);
            PropertyDeserializer<T> deserializer = this.properties.get(key.toLowerCase());
            if (deserializer == null) {
                throw new ParseException(String.format("Unknown node data property %s in part %s. Valid properties: '%s'.", key, dataPart, String.join((CharSequence)"', '", this.properties.keySet())));
            }
            try {
                deserializer.deserialize(nodeData, value);
            }
            catch (Exception e) {
                throw new ParseException(String.format("Invalid value for property %s: %s", key, e.getMessage()), e);
            }
        }
    }

    public static interface PropertyDeserializer<T extends NodeData> {
        public void deserialize(T var1, String var2);
    }
}

