/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.version.current;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.util.Colors;
import nl.aurorion.blockregen.version.api.Methods;
import nl.aurorion.blockregen.xseries.XBlock;
import nl.aurorion.blockregen.xseries.XEnchantment;
import nl.aurorion.blockregen.xseries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestMethods
implements Methods {
    @Generated
    private static final Logger log = Logger.getLogger(LatestMethods.class.getName());
    private final EquipmentSlot[] PLAYER_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.CHEST, EquipmentSlot.FEET, EquipmentSlot.HAND, EquipmentSlot.HEAD, EquipmentSlot.LEGS, EquipmentSlot.OFF_HAND};

    @Override
    public boolean isBarColorValid(@Nullable String string) {
        return this.parseColor(string) != null;
    }

    @Override
    @Nullable
    public BossBar createBossBar(@Nullable String text, @Nullable String color, @Nullable String style) {
        BarColor barColor = this.parseColor(color);
        BarStyle barStyle = this.parseStyle(style);
        if (barColor == null || barStyle == null) {
            return null;
        }
        return Bukkit.createBossBar((String)Colors.color(text), (BarColor)barColor, (BarStyle)barStyle, (BarFlag[])new BarFlag[0]);
    }

    @Override
    public boolean isBarStyleValid(@Nullable String string) {
        return this.parseStyle(string) != null;
    }

    @Nullable
    private BarStyle parseStyle(@Nullable String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        try {
            return BarStyle.valueOf((String)str.trim().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    private BarColor parseColor(@Nullable String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        try {
            return BarColor.valueOf((String)str.trim().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public void handleDropItemEvent(Player player, BlockState blockState, List<Item> items) {
        BlockDropItemEvent event = new BlockDropItemEvent(blockState.getBlock(), blockState, player, new ArrayList<Item>(items));
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getItems().isEmpty()) {
            log.fine(() -> "Drops got cancelled.");
            items.forEach(Entity::remove);
        }
    }

    @Override
    public void setType(@NotNull Block block, @NotNull XMaterial xMaterial) {
        XBlock.setType(block, xMaterial);
    }

    @Override
    @NotNull
    public XMaterial getType(@NotNull Block block) {
        return XMaterial.matchXMaterial(block.getType());
    }

    @Override
    @NotNull
    public ItemStack getItemInMainHand(@NotNull Player player) {
        return player.getInventory().getItemInMainHand();
    }

    @Nullable
    private ItemStack getRepairableItem(@NotNull Player player) {
        Enchantment mending = (Enchantment)XEnchantment.MENDING.get();
        if (mending == null) {
            log.fine("Mending not supported");
            return null;
        }
        for (EquipmentSlot slot : this.PLAYER_EQUIPMENT_SLOTS) {
            Damageable damageable;
            ItemMeta meta;
            ItemStack item = player.getInventory().getItem(slot);
            if (item == null || !((meta = item.getItemMeta()) instanceof Damageable) || !(damageable = (Damageable)meta).hasDamage() || meta.getEnchantLevel(mending) <= 0) continue;
            return item;
        }
        return null;
    }

    @Override
    public int applyMending(@NotNull Player player, int experience) {
        if (experience <= 0) {
            return 0;
        }
        ItemStack repairableItem = this.getRepairableItem(player);
        if (repairableItem == null) {
            return experience;
        }
        ItemMeta meta = repairableItem.getItemMeta();
        if (meta == null) {
            return experience;
        }
        Damageable damageable = (Damageable)meta;
        int totalDurability = experience * 2;
        int min = Math.min(totalDurability, damageable.getDamage());
        int experienceUsed = (int)Math.ceil((double)min / 2.0);
        damageable.setDamage(damageable.getDamage() - min);
        repairableItem.setItemMeta(meta);
        return this.applyMending(player, experience - experienceUsed);
    }
}

