/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.version.legacy;

import com.google.common.base.Strings;
import java.util.List;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.util.Colors;
import nl.aurorion.blockregen.version.api.Methods;
import nl.aurorion.blockregen.xseries.XBlock;
import nl.aurorion.blockregen.xseries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Colorable;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Wood;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyMethods
implements Methods {
    @Generated
    private static final Logger log = Logger.getLogger(LegacyMethods.class.getName());

    @Override
    public boolean isBarColorValid(@Nullable String string) {
        return this.parseColor(string) != null;
    }

    @Override
    @Nullable
    public BossBar createBossBar(@Nullable String text, @Nullable String color, @Nullable String style) {
        BarColor barColor = this.parseColor(color);
        BarStyle barStyle = this.parseStyle(style);
        if (barColor == null || barStyle == null) {
            return null;
        }
        return Bukkit.createBossBar((String)Colors.color(text), (BarColor)barColor, (BarStyle)barStyle, (BarFlag[])new BarFlag[0]);
    }

    @Override
    public boolean isBarStyleValid(@Nullable String string) {
        return this.parseStyle(string) != null;
    }

    @Nullable
    private BarStyle parseStyle(@Nullable String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        try {
            return BarStyle.valueOf((String)str.trim().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    private BarColor parseColor(@Nullable String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        try {
            return BarColor.valueOf((String)str.trim().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public void setType(@NotNull Block block, @NotNull XMaterial xMaterial) {
        if (xMaterial == XMaterial.WHEAT) {
            block.setType(Material.CROPS);
            block.getState().setData(new MaterialData(xMaterial.parseMaterial(), xMaterial.getData()));
            return;
        }
        XBlock.setType(block, xMaterial);
    }

    @Override
    @NotNull
    public XMaterial getType(@NotNull Block block) {
        byte dataValue;
        BlockState state = block.getState();
        MaterialData data = state.getData();
        if (data instanceof Wood) {
            TreeSpecies species = ((Wood)data).getSpecies();
            dataValue = species.getData();
        } else if (data instanceof Colorable) {
            DyeColor color = ((Colorable)data).getColor();
            dataValue = color.getWoolData();
        } else {
            dataValue = data.getData();
        }
        XMaterial xMaterial = XMaterial.matchXMaterial(String.format("%s:%d", block.getType().toString(), dataValue)).orElse(null);
        log.fine(() -> String.format("Parsed material %s:%d into %s", state.getType(), dataValue, xMaterial));
        return xMaterial;
    }

    @Override
    @NotNull
    public ItemStack getItemInMainHand(@NotNull Player player) {
        return player.getInventory().getItemInMainHand();
    }

    @Override
    public void handleDropItemEvent(Player player, BlockState blockState, List<Item> items) {
    }

    @Override
    public int applyMending(Player player, int experience) {
        return experience;
    }
}

