/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.version.legacy;

import java.util.HashMap;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.util.Serialization;
import nl.aurorion.blockregen.version.api.NodeData;
import nl.aurorion.blockregen.xseries.profiles.builder.XSkull;
import nl.aurorion.blockregen.xseries.profiles.exceptions.InvalidProfileContainerException;
import nl.aurorion.blockregen.xseries.profiles.objects.Profileable;
import org.bukkit.CropState;
import org.bukkit.TreeSpecies;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.material.Crops;
import org.bukkit.material.Directional;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Stairs;
import org.bukkit.material.Tree;
import org.bukkit.material.Wood;

public class LegacyNodeData
implements NodeData {
    @Generated
    private static final Logger log = Logger.getLogger(LegacyNodeData.class.getName());
    private BlockFace facing;
    private TreeSpecies treeSpecies;
    private Boolean inverted;
    private CropState cropState;
    private String skull;

    @Override
    public boolean matches(Block block) {
        Crops crops;
        Stairs stairs;
        Wood wood;
        Tree tree;
        Directional directional;
        MaterialData data = block.getState().getData();
        if (this.skull != null) {
            try {
                String profileString = XSkull.of(block).getDelegateProfile().getProfileValue();
                if (profileString != null && !profileString.equals(this.skull)) {
                    return false;
                }
            }
            catch (InvalidProfileContainerException e) {
                return false;
            }
        }
        if (data instanceof Directional && this.facing != null && (directional = (Directional)data).getFacing() != this.facing) {
            return false;
        }
        if (data instanceof Tree && this.facing != null && (tree = (Tree)data).getDirection() != this.facing) {
            return false;
        }
        if (data instanceof Wood && this.treeSpecies != null && (wood = (Wood)data).getSpecies() != this.treeSpecies) {
            return false;
        }
        if (data instanceof Stairs && this.inverted != null && (stairs = (Stairs)data).isInverted() != this.inverted.booleanValue()) {
            return false;
        }
        return !(data instanceof Crops) || this.cropState == null || (crops = (Crops)data).getState() == this.cropState;
    }

    @Override
    public void load(Block block) {
        MaterialData data = block.getState().getData();
        try {
            this.skull = XSkull.of(block).getDelegateProfile().getProfileValue();
        }
        catch (InvalidProfileContainerException invalidProfileContainerException) {
            // empty catch block
        }
        if (data instanceof Directional) {
            Directional directional = (Directional)data;
            this.facing = directional.getFacing();
        }
        if (data instanceof Tree) {
            Tree tree = (Tree)data;
            this.facing = tree.getDirection();
        }
        if (data instanceof Stairs) {
            Stairs stairs = (Stairs)data;
            this.inverted = stairs.isInverted();
        }
        if (data instanceof Crops) {
            Crops crops = (Crops)data;
            this.cropState = crops.getState();
        }
        if (data instanceof Wood) {
            Wood wood = (Wood)data;
            this.treeSpecies = wood.getSpecies();
        }
        log.fine(() -> String.format("Loaded block data %s (%s)", block.getType(), this));
    }

    @Override
    public void apply(Block block) {
        BlockState state = block.getState();
        MaterialData data = state.getData();
        if (data instanceof Directional && this.facing != null) {
            Directional directional = (Directional)data;
            directional.setFacingDirection(this.facing);
        }
        if (data instanceof Tree && this.facing != null) {
            Tree tree = (Tree)data;
            tree.setDirection(this.facing);
        }
        if (data instanceof Wood && this.treeSpecies != null) {
            Wood wood = (Wood)data;
            wood.setSpecies(this.treeSpecies);
        }
        if (data instanceof Stairs && this.inverted != null && this.inverted.booleanValue()) {
            Stairs stairs = (Stairs)data;
            stairs.setInverted(true);
        }
        if (data instanceof Crops && this.cropState != null) {
            Crops crops = (Crops)data;
            crops.setState(this.cropState);
        }
        if (this.skull != null) {
            XSkull.of(block).profile(Profileable.detect(this.skull)).apply();
        }
        state.setData(data);
    }

    @Override
    public boolean isEmpty() {
        return this.facing == null && this.treeSpecies == null && this.inverted == null && this.cropState == null;
    }

    @Override
    public String getPrettyString() {
        HashMap<String, Object> entries = new HashMap<String, Object>();
        entries.put("facing", this.facing);
        entries.put("species", this.treeSpecies);
        entries.put("inverted", this.inverted);
        entries.put("age", this.cropState == null ? null : Integer.valueOf(this.cropState.ordinal()));
        return Serialization.serializeNodeDataEntries(entries);
    }

    @Generated
    public String toString() {
        return "LegacyNodeData(facing=" + this.facing + ", treeSpecies=" + this.treeSpecies + ", inverted=" + this.inverted + ", cropState=" + this.cropState + ", skull=" + this.skull + ")";
    }

    @Generated
    public void setFacing(BlockFace facing) {
        this.facing = facing;
    }

    @Generated
    public void setTreeSpecies(TreeSpecies treeSpecies) {
        this.treeSpecies = treeSpecies;
    }

    @Generated
    public void setInverted(Boolean inverted) {
        this.inverted = inverted;
    }

    @Generated
    public void setCropState(CropState cropState) {
        this.cropState = cropState;
    }

    @Generated
    public void setSkull(String skull) {
        this.skull = skull;
    }

    @Generated
    public LegacyNodeData() {
    }
}

